/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.message.util;

import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.RaftMembershipList;
import io.zeebe.clustering.gossip.GossipDecoder;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import java.util.Iterator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class GossipMessageReader
implements BufferReader,
Iterator<Peer> {
    private Iterator<GossipDecoder.PeersDecoder> iterator;
    private final GossipDecoder bodyDecoder = new GossipDecoder();
    private final Peer currentPeer = new Peer();

    public void wrap(DirectBuffer values, int offset, int length) {
        this.bodyDecoder.wrap(values, offset, 0, 1);
        this.iterator = this.bodyDecoder.peers().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Peer next() {
        GossipDecoder.PeersDecoder decoder = this.iterator.next();
        this.currentPeer.reset();
        this.currentPeer.heartbeat().generation(decoder.generation()).version(decoder.version());
        for (GossipDecoder.PeersDecoder.EndpointsDecoder endpointsDecoder : decoder.endpoints()) {
            SocketAddress endpoint;
            switch (endpointsDecoder.endpointType()) {
                case CLIENT: {
                    endpoint = this.currentPeer.clientEndpoint();
                    break;
                }
                case MANAGEMENT: {
                    endpoint = this.currentPeer.managementEndpoint();
                    break;
                }
                case REPLICATION: {
                    endpoint = this.currentPeer.replicationEndpoint();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown endpoint type for peer: " + (Object)((Object)endpointsDecoder.endpointType()));
                }
            }
            MutableDirectBuffer hostBuffer = endpoint.getHostBuffer();
            int hostLength = endpointsDecoder.hostLength();
            endpoint.port(endpointsDecoder.port());
            endpoint.hostLength(hostLength);
            endpointsDecoder.getHost(hostBuffer, 0, hostLength);
            endpoint.host();
        }
        RaftMembershipList raftMemberships = this.currentPeer.raftMemberships();
        for (GossipDecoder.PeersDecoder.RaftMembershipsDecoder raftMembershipsDecoder : decoder.raftMemberships()) {
            raftMemberships.add(raftMembershipsDecoder);
        }
        this.currentPeer.state(decoder.state()).changeStateTime(-1L);
        return this.currentPeer;
    }
}

