/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.message.util;

import io.zeebe.broker.clustering.gossip.data.Heartbeat;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.RaftMembership;
import io.zeebe.broker.clustering.gossip.data.RaftMembershipList;
import io.zeebe.clustering.gossip.EndpointType;
import io.zeebe.clustering.gossip.GossipDecoder;
import io.zeebe.clustering.gossip.GossipEncoder;
import io.zeebe.clustering.gossip.MessageHeaderEncoder;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class GossipMessageWriter
implements BufferWriter {
    protected PeerList peers;
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final GossipEncoder bodyEncoder = new GossipEncoder();

    public GossipMessageWriter peers(PeerList peers) {
        this.peers = peers;
        return this;
    }

    public int getLength() {
        int size = this.peers.size();
        int peerEndpointsLength = GossipDecoder.PeersDecoder.EndpointsDecoder.sbeHeaderSize() + 3 * (GossipDecoder.PeersDecoder.EndpointsDecoder.sbeBlockLength() + GossipDecoder.PeersDecoder.EndpointsDecoder.hostHeaderLength());
        int peersLength = GossipDecoder.PeersDecoder.sbeHeaderSize() + size * (GossipDecoder.PeersDecoder.sbeBlockLength() + peerEndpointsLength);
        int length = this.bodyEncoder.sbeBlockLength() + peersLength;
        for (Peer current : this.peers) {
            length += current.clientEndpoint().hostLength();
            length += current.managementEndpoint().hostLength();
            length += current.replicationEndpoint().hostLength();
            length += GossipEncoder.PeersEncoder.RaftMembershipsEncoder.sbeHeaderSize();
            for (RaftMembership raftMembership : current.raftMemberships()) {
                length += GossipEncoder.PeersEncoder.RaftMembershipsEncoder.sbeBlockLength() + GossipEncoder.PeersEncoder.RaftMembershipsEncoder.topicNameHeaderLength() + raftMembership.topicNameLength();
            }
        }
        return length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        GossipEncoder.PeersEncoder encoder = this.bodyEncoder.wrap(buffer, offset).peersCount(this.peers.size());
        for (Peer current : this.peers) {
            Heartbeat heartbeat = current.heartbeat();
            SocketAddress clientEndpoint = current.clientEndpoint();
            SocketAddress managementEndpoint = current.managementEndpoint();
            SocketAddress replicationEndpoint = current.replicationEndpoint();
            MutableDirectBuffer clientHostBuffer = clientEndpoint.getHostBuffer();
            int clientHostLength = clientEndpoint.hostLength();
            int clientPort = clientEndpoint.port();
            MutableDirectBuffer managementHostBuffer = managementEndpoint.getHostBuffer();
            int managementHostLength = managementEndpoint.hostLength();
            int managementPort = managementEndpoint.port();
            MutableDirectBuffer replicationHostBuffer = replicationEndpoint.getHostBuffer();
            int replicationHostLength = replicationEndpoint.hostLength();
            int replicationPort = replicationEndpoint.port();
            GossipEncoder.PeersEncoder.EndpointsEncoder endpointsEncoder = encoder.next().state(current.state()).generation(heartbeat.generation()).version(heartbeat.version()).endpointsCount(3);
            endpointsEncoder.next().endpointType(EndpointType.CLIENT).port(clientPort).putHost((DirectBuffer)clientHostBuffer, 0, clientHostLength);
            endpointsEncoder.next().endpointType(EndpointType.MANAGEMENT).port(managementPort).putHost((DirectBuffer)managementHostBuffer, 0, managementHostLength);
            endpointsEncoder.next().endpointType(EndpointType.REPLICATION).port(replicationPort).putHost((DirectBuffer)replicationHostBuffer, 0, replicationHostLength);
            RaftMembershipList raftMemberships = current.raftMemberships();
            GossipEncoder.PeersEncoder.RaftMembershipsEncoder raftMembershipsEncoder = encoder.raftMembershipsCount(raftMemberships.size());
            for (RaftMembership raftMembership : raftMemberships) {
                raftMembershipsEncoder.next().partitionId(raftMembership.partitionId()).term(raftMembership.term()).state(raftMembership.state()).putTopicName(raftMembership.topicNameBuffer(), 0, raftMembership.topicNameLength());
            }
        }
    }
}

