/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerSelector;
import io.zeebe.broker.clustering.gossip.message.GossipRequest;
import io.zeebe.broker.clustering.gossip.message.GossipResponse;
import io.zeebe.broker.clustering.gossip.protocol.FailureDetection;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.transport.RequestResponseController;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import io.zeebe.util.state.StateMachineAgent;
import io.zeebe.util.state.StateMachineCommand;
import io.zeebe.util.state.TransitionState;
import io.zeebe.util.state.WaitState;

public class Dissemination {
    private static final int TRANSITION_DEFAULT = 0;
    private static final int TRANSITION_OPEN = 1;
    private static final int TRANSITION_FAILED = 2;
    private static final int TRANSITION_CLOSE = 3;
    private static final StateMachineCommand<DisseminationContext> OPEN_STATE_MACHINE_COMMAND = c -> {
        boolean open = c.tryTake(1);
        if (!open) {
            throw new IllegalStateException("Cannot open disseminator, has not been closed.");
        }
    };
    private static final StateMachineCommand<DisseminationContext> CLOSE_STATE_MACHINE_COMMAND = c -> {
        c.reset();
        boolean closed = c.tryTake(3);
        if (!closed) {
            throw new IllegalStateException("Cannot close state machine.");
        }
    };
    private final GossipContext gossipContext;
    private DisseminationContext disseminationContext;
    private final WaitState<DisseminationContext> closedState = c -> {};
    private final WaitState<DisseminationContext> acknowledgedState = c -> {};
    private final WaitState<DisseminationContext> failedState = c -> {};
    private final CloseRequestState closeRequestState = new CloseRequestState();
    private final ClosingState closingState = new ClosingState();
    private final SelectPeerState selectPeerState = new SelectPeerState();
    private final OpenRequestState openRequestState = new OpenRequestState();
    private final OpenState openState = new OpenState();
    private final ProcessResponseState processResponseState = new ProcessResponseState();
    private final OpenFailureDetectorState openFailureDetectorState = new OpenFailureDetectorState();
    private final StateMachineAgent<DisseminationContext> disseminationStateMachine;

    public Dissemination(GossipContext context, FailureDetection[] failureDetectors) {
        this.gossipContext = context;
        this.disseminationStateMachine = new StateMachineAgent(StateMachine.builder(s -> {
            this.disseminationContext = new DisseminationContext((StateMachine<?>)s, context.getLocalPeer(), failureDetectors);
            return this.disseminationContext;
        }).initialState(this.closedState).from(this.closedState).take(1).to((State)this.selectPeerState).from((State)this.selectPeerState).take(0).to((State)this.openRequestState).from((State)this.selectPeerState).take(3).to((State)this.closingState).from((State)this.openRequestState).take(0).to((State)this.openState).from((State)this.openState).take(0).to((State)this.processResponseState).from((State)this.openState).take(2).to((State)this.openFailureDetectorState).from((State)this.openState).take(3).to((State)this.closeRequestState).from((State)this.processResponseState).take(0).to(this.acknowledgedState).from((State)this.openFailureDetectorState).take(0).to(this.failedState).from(this.acknowledgedState).take(3).to((State)this.closeRequestState).from(this.failedState).take(3).to((State)this.closeRequestState).from((State)this.closeRequestState).take(0).to((State)this.closingState).from((State)this.closingState).take(0).to(this.closedState).build());
    }

    public void open() {
        this.disseminationStateMachine.addCommand(OPEN_STATE_MACHINE_COMMAND);
    }

    public void close() {
        this.disseminationStateMachine.addCommand(CLOSE_STATE_MACHINE_COMMAND);
    }

    public int doWork() {
        return this.disseminationStateMachine.doWork();
    }

    public boolean isAcknowledged() {
        return this.disseminationStateMachine.getCurrentState() == this.acknowledgedState;
    }

    public boolean isFailed() {
        return this.disseminationStateMachine.getCurrentState() == this.failedState;
    }

    public boolean isClosed() {
        return this.disseminationStateMachine.getCurrentState() == this.closedState;
    }

    class ClosingState
    implements State<DisseminationContext> {
        ClosingState() {
        }

        public int doWork(DisseminationContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            int workcount = 0;
            workcount += requestController.doWork();
            if (requestController.isClosed()) {
                ++workcount;
                context.take(0);
            }
            return workcount;
        }
    }

    class CloseRequestState
    implements TransitionState<DisseminationContext> {
        CloseRequestState() {
        }

        public void work(DisseminationContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            if (!requestController.isClosed()) {
                requestController.close();
            }
            context.take(0);
        }
    }

    class OpenFailureDetectorState
    implements TransitionState<DisseminationContext> {
        OpenFailureDetectorState() {
        }

        public void work(DisseminationContext context) throws Exception {
            PeerList peers = context.peers;
            Peer peer = context.peer;
            FailureDetection[] failureDetectors = context.failureDetectors;
            int idx = peers.find(peer);
            if (idx >= 0) {
                peers.get(idx, peer);
                if (peer.state() == PeerState.ALIVE) {
                    FailureDetection detector = null;
                    for (int k = 0; k < failureDetectors.length; ++k) {
                        FailureDetection failureDetection = failureDetectors[k];
                        if (failureDetection.isPeerEqualTo(peer)) {
                            detector = null;
                            break;
                        }
                        if (!failureDetection.isClosed()) continue;
                        detector = failureDetection;
                    }
                    if (detector != null) {
                        detector.open(peer);
                    }
                }
            }
            context.take(0);
        }
    }

    class ProcessResponseState
    implements TransitionState<DisseminationContext> {
        ProcessResponseState() {
        }

        public void work(DisseminationContext context) throws Exception {
            GossipResponse response = context.response;
            PeerList peers = context.peers;
            peers.merge(response.peers());
            context.take(0);
        }
    }

    class OpenState
    implements State<DisseminationContext> {
        OpenState() {
        }

        public int doWork(DisseminationContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            int workcount = 0;
            workcount += requestController.doWork();
            if (requestController.isResponseAvailable()) {
                ++workcount;
                context.take(0);
            } else if (requestController.isFailed()) {
                ++workcount;
                context.take(2);
            }
            return workcount;
        }
    }

    class OpenRequestState
    implements TransitionState<DisseminationContext> {
        OpenRequestState() {
        }

        public void work(DisseminationContext context) throws Exception {
            GossipRequest request = context.request;
            PeerList peers = context.peers;
            RequestResponseController requestController = context.requestController;
            Peer peer = context.peer;
            request.peers(peers);
            SocketAddress endpoint = peer.managementEndpoint();
            requestController.open(endpoint, (BufferWriter)request, (BufferReader)context.response);
            context.take(0);
        }
    }

    class SelectPeerState
    implements TransitionState<DisseminationContext> {
        SelectPeerState() {
        }

        public void work(DisseminationContext context) throws Exception {
            PeerSelector peerSelector = context.peerSelector;
            Peer peer = context.peer;
            Peer[] exclusions = context.exclusions;
            if (peerSelector.next(peer, exclusions)) {
                context.take(0);
            } else {
                context.take(3);
            }
        }
    }

    class DisseminationContext
    extends SimpleStateMachineContext {
        final Peer peer;
        final PeerList peers;
        final GossipRequest request;
        final GossipResponse response;
        final RequestResponseController requestController;
        final PeerSelector peerSelector;
        final Peer[] exclusions;
        final FailureDetection[] failureDetectors;

        DisseminationContext(StateMachine<?> stateMachine, Peer localPeer, FailureDetection[] failureDetectors) {
            super(stateMachine);
            this.peer = new Peer();
            this.peers = Dissemination.this.gossipContext.getPeers();
            this.peerSelector = Dissemination.this.gossipContext.getPeerSelector();
            this.exclusions = new Peer[1];
            this.exclusions[0] = localPeer;
            this.request = new GossipRequest();
            this.response = new GossipResponse();
            GossipConfiguration config = Dissemination.this.gossipContext.getConfig();
            this.requestController = new RequestResponseController(Dissemination.this.gossipContext.getClientTransport(), config.disseminationTimeout);
            this.failureDetectors = failureDetectors;
        }

        public void reset() {
            this.peer.reset();
        }
    }
}

