/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerSelector;
import io.zeebe.broker.clustering.gossip.message.GossipResponse;
import io.zeebe.broker.clustering.gossip.message.ProbeRequest;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.RequestResponseController;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import io.zeebe.util.state.StateMachineAgent;
import io.zeebe.util.state.StateMachineCommand;
import io.zeebe.util.state.TransitionState;
import io.zeebe.util.state.WaitState;
import org.agrona.DirectBuffer;

public class FailureDetection {
    private static final int TRANSITION_DEFAULT = 0;
    private static final int TRANSITION_OPEN = 1;
    private static final int TRANSITION_FAILED = 2;
    private static final int TRANSITION_CLOSE = 3;
    private static final StateMachineCommand<FailureDetectionContext> OPEN_STATE_MACHINE_COMMAND = c -> {
        boolean open = c.tryTake(1);
        if (!open) {
            throw new IllegalStateException("Cannot open disseminator, has not been closed.");
        }
    };
    private static final StateMachineCommand<FailureDetectionContext> CLOSE_STATE_MACHINE_COMMAND = c -> {
        c.reset();
        boolean closed = c.tryTake(3);
        if (!closed) {
            throw new IllegalStateException("Cannot close state machine.");
        }
    };
    private final GossipContext gossipContext;
    private FailureDetectionContext failureDetectionContext;
    private final WaitState<FailureDetectionContext> closedState = s -> {};
    private final WaitState<FailureDetectionContext> acknowledgedState = s -> {};
    private final WaitState<FailureDetectionContext> failedState = s -> {};
    private final CloseRequestsState closeRequestsState = new CloseRequestsState();
    private final ClosingState closingState = new ClosingState();
    private final OpenRequestState openingState = new OpenRequestState();
    private final OpenState openState = new OpenState();
    private final SuspectPeerState suspectPeerState = new SuspectPeerState();
    private final ProcessResponseState processResponseState = new ProcessResponseState();
    private final StateMachineAgent<FailureDetectionContext> failureDetectionStateMachine;

    public FailureDetection(GossipContext context) {
        this.gossipContext = context;
        this.failureDetectionStateMachine = new StateMachineAgent(StateMachine.builder(s -> {
            this.failureDetectionContext = new FailureDetectionContext((StateMachine<?>)s, context.getLocalPeer());
            return this.failureDetectionContext;
        }).initialState(this.closedState).from(this.closedState).take(1).to((State)this.openingState).from((State)this.openingState).take(0).to((State)this.openState).from((State)this.openState).take(0).to((State)this.processResponseState).from((State)this.openState).take(2).to((State)this.suspectPeerState).from((State)this.openState).take(3).to((State)this.closeRequestsState).from((State)this.processResponseState).take(0).to(this.acknowledgedState).from((State)this.suspectPeerState).take(0).to(this.failedState).from(this.acknowledgedState).take(3).to((State)this.closeRequestsState).from(this.failedState).take(3).to((State)this.closeRequestsState).from((State)this.closeRequestsState).take(0).to((State)this.closingState).from((State)this.closingState).take(0).to(this.closedState).build());
    }

    public boolean isPeerEqualTo(Peer peer) {
        return this.failureDetectionContext.peer.managementEndpoint().compareTo(peer.managementEndpoint()) == 0;
    }

    public void open(Peer peer) {
        this.failureDetectionContext.peer.wrap(peer);
        this.failureDetectionStateMachine.addCommand(OPEN_STATE_MACHINE_COMMAND);
    }

    public void close() {
        this.failureDetectionStateMachine.addCommand(CLOSE_STATE_MACHINE_COMMAND);
    }

    public int doWork() {
        return this.failureDetectionStateMachine.doWork();
    }

    public boolean isClosed() {
        return this.failureDetectionStateMachine.getCurrentState() == this.closedState;
    }

    public boolean isAcknowledged() {
        return this.failureDetectionStateMachine.getCurrentState() == this.acknowledgedState;
    }

    public boolean isFailed() {
        return this.failureDetectionStateMachine.getCurrentState() == this.failedState;
    }

    class ClosingState
    implements State<FailureDetectionContext> {
        ClosingState() {
        }

        public int doWork(FailureDetectionContext context) throws Exception {
            RequestResponseController[] requestControllers = context.requestControllers;
            int workcount = 0;
            int closed = 0;
            for (int i = 0; i < requestControllers.length; ++i) {
                RequestResponseController controller = requestControllers[i];
                workcount += controller.doWork();
                if (!controller.isClosed()) continue;
                ++closed;
                ++workcount;
            }
            if (requestControllers.length == closed) {
                ++workcount;
                context.take(0);
            }
            return workcount;
        }
    }

    class CloseRequestsState
    implements TransitionState<FailureDetectionContext> {
        CloseRequestsState() {
        }

        public void work(FailureDetectionContext context) throws Exception {
            RequestResponseController[] requestControllers = context.requestControllers;
            int targetLength = context.targetLength;
            for (int i = 0; i < targetLength; ++i) {
                RequestResponseController controller = requestControllers[i];
                if (controller.isClosed()) continue;
                controller.close();
            }
            context.take(0);
        }
    }

    class SuspectPeerState
    implements TransitionState<FailureDetectionContext> {
        SuspectPeerState() {
        }

        public void work(FailureDetectionContext context) throws Exception {
            PeerList peers = context.peers;
            Peer peer = context.peer;
            int idx = peers.find(peer);
            if (idx >= 0) {
                peers.get(idx, peer);
                if (peer.state() == PeerState.ALIVE) {
                    peer.suspect();
                    peers.set(idx, peer);
                }
            }
            context.take(0);
        }
    }

    class ProcessResponseState
    implements TransitionState<FailureDetectionContext> {
        ProcessResponseState() {
        }

        public void work(FailureDetectionContext context) throws Exception {
            GossipResponse response = context.response;
            PeerList peers = context.peers;
            DirectBuffer responseBuffer = context.responseBuffer;
            int responseLength = context.responseLength;
            response.wrap(responseBuffer, 0, responseLength);
            peers.merge(response.peers());
            context.take(0);
        }
    }

    class OpenState
    implements State<FailureDetectionContext> {
        OpenState() {
        }

        public int doWork(FailureDetectionContext context) throws Exception {
            RequestResponseController[] requestControllers = context.requestControllers;
            int targetLength = context.targetLength;
            int workcount = 0;
            int failed = 0;
            for (int i = 0; i < targetLength; ++i) {
                RequestResponseController controller = requestControllers[i];
                workcount += controller.doWork();
                if (controller.isResponseAvailable()) {
                    ++workcount;
                    context.responseBuffer = controller.getResponseBuffer();
                    context.responseLength = controller.getResponseLength();
                    context.take(0);
                    break;
                }
                if (!controller.isFailed()) continue;
                ++failed;
            }
            if (failed == targetLength) {
                ++workcount;
                context.take(2);
            }
            return workcount;
        }
    }

    class OpenRequestState
    implements TransitionState<FailureDetectionContext> {
        OpenRequestState() {
        }

        public void work(FailureDetectionContext context) throws Exception {
            ProbeRequest request = context.request;
            Peer peer = context.peer;
            int targetLength = context.targetLength;
            RequestResponseController[] requestControllers = context.requestControllers;
            Peer[] targets = context.targets;
            request.reset();
            request.target(peer.managementEndpoint());
            for (int i = 0; i < targetLength; ++i) {
                RequestResponseController controller = requestControllers[i];
                Peer target = targets[i];
                controller.open(target.managementEndpoint(), (BufferWriter)request, null);
            }
            context.take(0);
        }
    }

    class SelectPeersState
    implements TransitionState<FailureDetectionContext> {
        SelectPeersState() {
        }

        public void work(FailureDetectionContext context) throws Exception {
            PeerSelector peerSelector = context.peerSelector;
            Peer[] targets = context.targets;
            Peer[] exclusions = context.exclusions;
            context.targetLength = peerSelector.next(targets.length, targets, exclusions);
            context.take(0);
        }
    }

    class FailureDetectionContext
    extends SimpleStateMachineContext {
        DirectBuffer responseBuffer;
        int responseLength;
        final PeerList peers;
        final PeerSelector peerSelector;
        final RequestResponseController[] requestControllers;
        final Peer peer;
        final Peer[] targets;
        int targetLength;
        final Peer[] exclusions;
        final ProbeRequest request;
        final GossipResponse response;

        FailureDetectionContext(StateMachine<?> stateMachine, Peer localPeer) {
            super(stateMachine);
            this.peer = new Peer();
            this.peers = FailureDetection.this.gossipContext.getPeers();
            this.request = new ProbeRequest();
            this.response = new GossipResponse();
            ClientTransport clientTransport = FailureDetection.this.gossipContext.getClientTransport();
            GossipConfiguration config = FailureDetection.this.gossipContext.getConfig();
            PeerSelector peerSelector = FailureDetection.this.gossipContext.getPeerSelector();
            int capacity = config.failureDetectionCapacity;
            this.peerSelector = peerSelector;
            this.requestControllers = new RequestResponseController[capacity];
            this.targets = new Peer[capacity];
            this.targetLength = 0;
            this.exclusions = new Peer[2];
            this.exclusions[0] = localPeer;
            this.exclusions[1] = this.peer;
            for (int i = 0; i < capacity; ++i) {
                this.targets[i] = new Peer();
                this.requestControllers[i] = new RequestResponseController(clientTransport, config.failureDetectorTimeout);
            }
        }

        public void reset() {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].reset();
            }
            this.targetLength = 0;
            this.responseBuffer = null;
            this.responseLength = 0;
            this.request.reset();
        }
    }
}

