/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Heartbeat;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.message.GossipRequest;
import io.zeebe.broker.clustering.gossip.message.GossipResponse;
import io.zeebe.broker.clustering.gossip.protocol.Dissemination;
import io.zeebe.broker.clustering.gossip.protocol.FailureDetection;
import io.zeebe.broker.clustering.gossip.protocol.Probe;
import io.zeebe.broker.clustering.gossip.protocol.Suspicion;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.util.StreamUtil;
import io.zeebe.util.buffer.BufferWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;

public class GossipController {
    private final Peer localPeer;
    private final PeerList peers;
    private final Peer tmp;
    private final GossipContext context;
    private long lastDissemination = 0L;
    private long lastStorage = -1L;
    private final PeerList diff;
    private final GossipRequest gossipRequest;
    private final GossipResponse gossipResponse;
    protected final ServerResponse response = new ServerResponse();
    private Dissemination[] disseminators;
    private FailureDetection[] failureDetectors;
    private Suspicion suspicion;
    private Probe[] proberHandlers;
    private final String gossipFileName;

    public GossipController(GossipContext context) {
        this.localPeer = context.getLocalPeer();
        this.peers = context.getPeers();
        this.context = context;
        GossipConfiguration config = context.getConfig();
        this.diff = new PeerList(config.peerCapacity);
        this.gossipRequest = new GossipRequest();
        this.gossipResponse = new GossipResponse();
        this.gossipFileName = config.fileName();
        this.tmp = new Peer();
        this.tmp.reset();
    }

    public void open() {
        GossipConfiguration config = this.context.getConfig();
        this.createFailureDetectors(config);
        this.createDisseminators(config);
        this.createSuspicion(config);
        this.createProbe(config);
    }

    protected void createDisseminators(GossipConfiguration config) {
        this.disseminators = new Dissemination[config.disseminatorCapacity];
        for (int i = 0; i < this.disseminators.length; ++i) {
            this.disseminators[i] = new Dissemination(this.context, this.failureDetectors);
        }
    }

    protected void createFailureDetectors(GossipConfiguration config) {
        this.failureDetectors = new FailureDetection[config.failureDetectionCapacity];
        for (int i = 0; i < this.failureDetectors.length; ++i) {
            this.failureDetectors[i] = new FailureDetection(this.context);
        }
    }

    protected void createProbe(GossipConfiguration config) {
        this.proberHandlers = new Probe[config.probeCapacity];
        for (int i = 0; i < this.proberHandlers.length; ++i) {
            this.proberHandlers[i] = new Probe(this.context);
        }
    }

    protected void createSuspicion(GossipConfiguration config) {
        this.suspicion = new Suspicion(this.context);
    }

    public void close() {
        int i;
        for (i = 0; i < this.disseminators.length; ++i) {
            this.disseminators[i].close();
        }
        for (i = 0; i < this.failureDetectors.length; ++i) {
            this.failureDetectors[i].close();
        }
        for (i = 0; i < this.proberHandlers.length; ++i) {
            this.proberHandlers[i].close();
        }
        this.suspicion.close();
        this.peers.close();
        this.diff.close();
    }

    public int doWork() {
        int workcount = 0;
        workcount += this.doDissemination();
        workcount += this.doFailureDetection();
        workcount += this.scheduleNextDissemination();
        workcount += this.doSuspicion();
        workcount += this.doProbe();
        return workcount += this.doStore();
    }

    protected int doDissemination() {
        int workcount = 0;
        for (int i = 0; i < this.disseminators.length; ++i) {
            Dissemination disseminator = this.disseminators[i];
            workcount += disseminator.doWork();
            if (!disseminator.isAcknowledged() && !disseminator.isFailed()) continue;
            disseminator.close();
        }
        return workcount;
    }

    protected int doFailureDetection() {
        int workcount = 0;
        for (int i = 0; i < this.failureDetectors.length; ++i) {
            FailureDetection failureDetector = this.failureDetectors[i];
            workcount += failureDetector.doWork();
            if (!failureDetector.isAcknowledged() && !failureDetector.isFailed()) continue;
            failureDetector.close();
        }
        return workcount;
    }

    protected int doSuspicion() {
        return this.suspicion.doWork();
    }

    protected int doProbe() {
        int workcount = 0;
        for (int i = 0; i < this.proberHandlers.length; ++i) {
            Probe prober = this.proberHandlers[i];
            workcount += prober.doWork();
            if (!prober.isAcknowledged() && !prober.isFailed()) continue;
            prober.close();
        }
        return workcount;
    }

    protected int doStore() {
        boolean elapsed;
        int workcount = 0;
        GossipConfiguration config = this.context.getConfig();
        long now = System.currentTimeMillis();
        int interval = config.peersStorageInterval;
        boolean bl = interval > 0 ? now >= TimeUnit.MINUTES.toMillis(interval) + this.lastStorage : (elapsed = false);
        if (elapsed) {
            ++workcount;
            File file = new File(this.gossipFileName);
            MessageDigest messageDigest = StreamUtil.getSha1Digest();
            try (InputStream is = this.peers.toInputStream();){
                StreamUtil.write((File)file, (InputStream)is, (MessageDigest)messageDigest);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lastStorage = now;
        }
        return workcount;
    }

    protected int scheduleNextDissemination() {
        boolean elapsed;
        int workcount = 0;
        long now = System.currentTimeMillis();
        GossipConfiguration config = this.context.getConfig();
        int interval = config.disseminationInterval;
        boolean bl = elapsed = interval > 0 && now >= TimeUnit.SECONDS.toMillis(interval) + this.lastDissemination;
        if (elapsed) {
            this.localPeer.alive();
            Heartbeat heartbeat = this.localPeer.heartbeat();
            heartbeat.version(heartbeat.version() + 1);
            this.peers.update(this.localPeer);
            this.lastDissemination = now;
            Dissemination disseminator = this.getClosedDisseminator();
            if (disseminator != null) {
                ++workcount;
                disseminator.open();
            }
        }
        return workcount;
    }

    protected Dissemination getClosedDisseminator() {
        Dissemination dissemination = null;
        for (int i = 0; i < this.disseminators.length; ++i) {
            if (!this.disseminators[i].isClosed()) continue;
            dissemination = this.disseminators[i];
            break;
        }
        return dissemination;
    }

    protected Probe getClosedProbe() {
        Probe probe = null;
        for (int i = 0; i < this.proberHandlers.length; ++i) {
            if (!this.proberHandlers[i].isClosed()) continue;
            probe = this.proberHandlers[i];
            break;
        }
        return probe;
    }

    public boolean onGossipRequest(DirectBuffer buffer, int offset, int length, ServerOutput output, RemoteAddress requestAddress, long requestId) {
        this.gossipRequest.wrap(buffer, offset, length);
        this.diff.clear();
        this.peers.merge(this.gossipRequest.peers(), this.diff);
        int idx = this.peers.find(this.localPeer);
        if (idx > 0) {
            this.peers.get(idx, this.tmp);
            if (this.tmp.state() != PeerState.ALIVE) {
                this.localPeer.alive();
                this.localPeer.heartbeat().generation(System.currentTimeMillis());
                this.peers.set(idx, this.localPeer);
                int pos = this.diff.find(this.localPeer);
                if (pos >= 0) {
                    this.diff.set(idx, this.localPeer);
                } else {
                    this.diff.add(~idx, this.localPeer);
                }
            }
        }
        this.gossipResponse.peers(this.diff);
        this.response.reset().remoteAddress(requestAddress).requestId(requestId).writer((BufferWriter)this.gossipResponse);
        return output.sendResponse(this.response);
    }

    public boolean onProbeRequest(DirectBuffer buffer, int offset, int length, ServerOutput output, RemoteAddress requestAddress, long requestId) {
        Probe probeHandler = this.getClosedProbe();
        if (probeHandler != null) {
            probeHandler.open(buffer, offset, length, output, requestAddress, requestId);
        }
        return true;
    }
}

