/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.message.GossipRequest;
import io.zeebe.broker.clustering.gossip.message.GossipResponse;
import io.zeebe.broker.clustering.gossip.message.ProbeRequest;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RequestResponseController;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import io.zeebe.util.state.StateMachineAgent;
import io.zeebe.util.state.StateMachineCommand;
import io.zeebe.util.state.TransitionState;
import io.zeebe.util.state.WaitState;
import org.agrona.DirectBuffer;

public class Probe {
    private static final int TRANSITION_DEFAULT = 0;
    private static final int TRANSITION_OPEN = 1;
    private static final int TRANSITION_FAILED = 2;
    private static final int TRANSITION_CLOSE = 3;
    private static final StateMachineCommand<ProbeContext> OPEN_STATE_MACHINE_COMMAND = c -> {
        boolean open = c.tryTake(1);
        if (!open) {
            throw new IllegalStateException("Cannot open disseminator, has not been closed.");
        }
    };
    private static final StateMachineCommand<ProbeContext> CLOSE_STATE_MACHINE_COMMAND = c -> {
        boolean closed = c.tryTake(3);
        if (!closed) {
            throw new IllegalStateException("Cannot close state machine.");
        }
    };
    private final GossipContext gossipContext;
    private ProbeContext probeContext;
    private final WaitState<ProbeContext> closedState = c -> {};
    private final WaitState<ProbeContext> acknowledgedState = c -> {};
    private final WaitState<ProbeContext> failedState = c -> {};
    private final CloseRequestState closeRequestState = new CloseRequestState();
    private final ClosingState closingState = new ClosingState();
    private final OpeningState openingState = new OpeningState();
    private final OpenState openState = new OpenState();
    private final ProcessResponseState processResponseState = new ProcessResponseState();
    private final ForwardResponseState sendResponseState = new ForwardResponseState();
    private final StateMachineAgent<ProbeContext> probeStateMachine;

    public Probe(GossipContext context) {
        this.gossipContext = context;
        this.probeStateMachine = new StateMachineAgent(StateMachine.builder(s -> {
            this.probeContext = new ProbeContext((StateMachine<?>)s);
            return this.probeContext;
        }).initialState(this.closedState).from(this.closedState).take(1).to((State)this.openingState).from((State)this.openingState).take(0).to((State)this.openState).from((State)this.openState).take(0).to((State)this.processResponseState).from((State)this.openState).take(2).to(this.failedState).from((State)this.openState).take(3).to((State)this.closeRequestState).from((State)this.processResponseState).take(0).to((State)this.sendResponseState).from((State)this.sendResponseState).take(0).to(this.acknowledgedState).from((State)this.sendResponseState).take(2).to(this.failedState).from((State)this.sendResponseState).take(3).to((State)this.closeRequestState).from(this.acknowledgedState).take(3).to((State)this.closeRequestState).from(this.failedState).take(3).to((State)this.closeRequestState).from((State)this.closeRequestState).take(0).to((State)this.closingState).from((State)this.closingState).take(0).to(this.closedState).build());
    }

    public void open(DirectBuffer buffer, int offset, int length, ServerOutput output, RemoteAddress requestAddress, long requestId) {
        this.probeContext.requestStreamId = requestAddress.getStreamId();
        this.probeContext.requestId = requestId;
        this.probeContext.probeRequest.wrap(buffer, offset, length);
        this.probeStateMachine.addCommand(OPEN_STATE_MACHINE_COMMAND);
    }

    public void close() {
        this.probeContext.reset();
        this.probeStateMachine.addCommand(CLOSE_STATE_MACHINE_COMMAND);
    }

    public int doWork() {
        return this.probeStateMachine.doWork();
    }

    public boolean isAcknowledged() {
        return this.probeStateMachine.getCurrentState() == this.acknowledgedState;
    }

    public boolean isFailed() {
        return this.probeStateMachine.getCurrentState() == this.failedState;
    }

    public boolean isClosed() {
        return this.probeStateMachine.getCurrentState() == this.closedState;
    }

    static class ClosingState
    implements State<ProbeContext> {
        ClosingState() {
        }

        public int doWork(ProbeContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            int workcount = 0;
            workcount += requestController.doWork();
            if (requestController.isClosed()) {
                ++workcount;
                context.take(0);
            }
            return workcount;
        }
    }

    static class CloseRequestState
    implements TransitionState<ProbeContext> {
        CloseRequestState() {
        }

        public void work(ProbeContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            if (!requestController.isClosed()) {
                requestController.close();
            }
            context.take(0);
        }
    }

    static class ForwardResponseState
    implements State<ProbeContext> {
        ForwardResponseState() {
        }

        public int doWork(ProbeContext context) throws Exception {
            int channelId = context.requestStreamId;
            long requestId = context.requestId;
            GossipResponse gossipResponse = context.gossipResponse;
            int workcount = 0;
            context.response.reset().remoteStreamId(channelId).requestId(requestId).writer((BufferWriter)gossipResponse);
            boolean success = context.output.sendResponse(context.response);
            if (success) {
                ++workcount;
                context.take(0);
            }
            return workcount;
        }
    }

    static class ProcessResponseState
    implements TransitionState<ProbeContext> {
        ProcessResponseState() {
        }

        public void work(ProbeContext context) throws Exception {
            GossipResponse gossipResponse = context.gossipResponse;
            PeerList peers = context.peers;
            peers.merge(gossipResponse.peers());
            context.take(0);
        }
    }

    static class OpenState
    implements State<ProbeContext> {
        OpenState() {
        }

        public int doWork(ProbeContext context) throws Exception {
            RequestResponseController requestController = context.requestController;
            int workcount = 0;
            workcount += requestController.doWork();
            if (requestController.isResponseAvailable()) {
                ++workcount;
                context.take(0);
            } else if (requestController.isFailed()) {
                ++workcount;
                context.take(2);
            }
            return workcount;
        }
    }

    static class OpeningState
    implements TransitionState<ProbeContext> {
        OpeningState() {
        }

        public void work(ProbeContext context) throws Exception {
            GossipRequest gossipRequest = context.gossipRequest;
            PeerList peers = context.peers;
            ProbeRequest probeRequest = context.probeRequest;
            RequestResponseController requestController = context.requestController;
            gossipRequest.peers(peers);
            SocketAddress target = probeRequest.target();
            requestController.open(target, (BufferWriter)gossipRequest, (BufferReader)context.gossipResponse);
            context.take(0);
        }
    }

    class ProbeContext
    extends SimpleStateMachineContext {
        final PeerList peers;
        final RequestResponseController requestController;
        int requestStreamId;
        long requestId;
        final ProbeRequest probeRequest;
        final GossipRequest gossipRequest;
        final GossipResponse gossipResponse;
        final ServerOutput output;
        final ServerResponse response;

        ProbeContext(StateMachine<?> stateMachine) {
            super(stateMachine);
            this.response = new ServerResponse();
            this.peers = Probe.this.gossipContext.getPeers();
            GossipConfiguration config = Probe.this.gossipContext.getConfig();
            ClientTransport clientTransport = Probe.this.gossipContext.getClientTransport();
            this.requestController = new RequestResponseController(clientTransport, config.probeTimeout);
            this.output = Probe.this.gossipContext.getServerTransport().getOutput();
            this.probeRequest = new ProbeRequest();
            this.gossipRequest = new GossipRequest();
            this.gossipResponse = new GossipResponse();
        }

        public void reset() {
            this.requestStreamId = -1;
            this.requestId = -1L;
            this.probeRequest.reset();
        }
    }
}

