/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerListIterator;
import io.zeebe.clustering.gossip.PeerState;
import java.util.concurrent.TimeUnit;

public class Suspicion {
    private int timeout;
    private final PeerList peers;
    private final PeerListIterator iterator;

    public Suspicion(GossipContext context) {
        GossipConfiguration config = context.getConfig();
        this.timeout = config.suspicionTimeout;
        this.peers = context.getPeers();
        this.iterator = new PeerListIterator(this.peers);
    }

    public void open() {
    }

    public void close() {
    }

    public int doWork() {
        int workcount = 0;
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            Peer peer = this.iterator.next();
            if (peer.state() != PeerState.SUSPECT) continue;
            long suspectTime = peer.changeStateTime();
            if (System.currentTimeMillis() <= suspectTime + TimeUnit.SECONDS.toMillis(this.timeout)) continue;
            ++workcount;
            peer.dead();
            this.peers.set(this.iterator.position(), peer);
        }
        return workcount;
    }
}

