/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.protocol.util;

import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerListIterator;
import io.zeebe.broker.clustering.gossip.data.PeerSelector;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.transport.SocketAddress;
import java.util.Random;

public class SimplePeerSelector
implements PeerSelector {
    private final Random random = new Random();
    private final PeerList peers;
    private final PeerList shuffled;
    private final PeerListIterator iterator;
    private final Peer curr = new Peer();

    public SimplePeerSelector(PeerList peers) {
        this.peers = peers;
        this.shuffled = new PeerList(peers.capacity());
        this.shuffled.addAll(peers);
        this.iterator = this.shuffled.iterator();
        peers.registerListener(this.shuffled::append);
    }

    @Override
    public void close() {
        this.shuffled.close();
    }

    @Override
    public boolean next(Peer dst, Peer[] exclusions) {
        for (int i = 0; i < this.peers.size(); ++i) {
            if (!this.iterator.hasNext()) {
                this.shuffled.shuffle();
                this.iterator.reset();
            }
            if (!this.iterator.hasNext()) continue;
            this.curr.wrap(this.iterator.next());
            int idx = this.peers.find(this.curr);
            if (idx < 0) continue;
            this.peers.get(idx, this.curr);
            if (this.curr.state() == PeerState.DEAD) continue;
            if (exclusions != null && this.isExcluded(this.curr, exclusions)) break;
            dst.reset();
            dst.wrap(this.curr);
            return true;
        }
        return false;
    }

    @Override
    public int next(int max, Peer[] dst, Peer[] exclusions) {
        int n = this.shuffled.size();
        int dstIdx = 0;
        for (int i = 0; i < n * 3 && dstIdx < max; ++i) {
            int idx = this.random.nextInt(n);
            this.shuffled.get(idx, this.curr);
            SocketAddress currEndpoint = this.curr.managementEndpoint();
            if (this.curr.state() != PeerState.ALIVE || this.isExcluded(this.curr, exclusions)) continue;
            boolean shouldAdd = true;
            for (int j = 0; j < dstIdx; ++j) {
                if (currEndpoint.compareTo(dst[j].managementEndpoint()) != 0) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            int peerIdx = this.peers.find(this.curr);
            if (idx < 0) continue;
            this.peers.get(peerIdx, this.curr);
            dst[dstIdx].reset();
            dst[dstIdx].wrap(this.curr);
            ++dstIdx;
        }
        return dstIdx;
    }

    protected boolean isExcluded(Peer peer, Peer[] exclusions) {
        SocketAddress peerEndpoint = peer.managementEndpoint();
        for (int i = 0; i < exclusions.length; ++i) {
            SocketAddress excludedEndpoint = exclusions[i].managementEndpoint();
            if (excludedEndpoint.compareTo(peerEndpoint) != 0) continue;
            return true;
        }
        return false;
    }
}

