/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.service;

import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.gossip.data.PeerSelector;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ClientTransport;

public class GossipContextService
implements Service<GossipContext> {
    private final Injector<PeerList> peerListInjector = new Injector();
    private final Injector<Peer> localPeerInjector = new Injector();
    private final Injector<PeerSelector> peerSelectorInjector = new Injector();
    protected final Injector<ClientTransport> clientTransportInjector = new Injector();
    protected final Injector<BufferingServerTransport> managementApiTransportInjector = new Injector();
    private final GossipConfiguration config;
    private GossipContext context;

    public GossipContextService(GossipConfiguration config) {
        this.config = config;
    }

    public void start(ServiceStartContext startContext) {
        ClientTransport clientTransport = (ClientTransport)this.clientTransportInjector.getValue();
        BufferingServerTransport serverTransport = (BufferingServerTransport)this.managementApiTransportInjector.getValue();
        PeerList peers = (PeerList)this.peerListInjector.getValue();
        Peer localPeer = (Peer)this.localPeerInjector.getValue();
        PeerSelector peerSelector = (PeerSelector)this.peerSelectorInjector.getValue();
        this.context = new GossipContext();
        this.context.setLocalPeer(localPeer);
        this.context.setPeers(peers);
        this.context.setConfig(this.config);
        this.context.setClientTransport(clientTransport);
        this.context.setServerTransport(serverTransport);
        this.context.setPeerSelector(peerSelector);
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public GossipContext get() {
        return this.context;
    }

    public Injector<PeerList> getPeerListInjector() {
        return this.peerListInjector;
    }

    public Injector<PeerSelector> getPeerSelectorInjector() {
        return this.peerSelectorInjector;
    }

    public Injector<Peer> getLocalPeerInjector() {
        return this.localPeerInjector;
    }

    public Injector<ClientTransport> getClientTransportInjector() {
        return this.clientTransportInjector;
    }

    public Injector<BufferingServerTransport> getManagementApiTransportInjector() {
        return this.managementApiTransportInjector;
    }
}

