/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.service;

import io.zeebe.broker.clustering.gossip.Gossip;
import io.zeebe.broker.clustering.gossip.GossipContext;
import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.LangUtil;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;
import java.io.File;

public class GossipService
implements Service<Gossip> {
    private final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    private final Injector<GossipContext> gossipContextInjector = new Injector();
    private Gossip gossip;
    private GossipContext gossipContext;
    private ActorReference actorRef;

    public void start(ServiceStartContext startContext) {
        ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
        this.gossipContext = (GossipContext)this.gossipContextInjector.getValue();
        startContext.run(() -> {
            GossipConfiguration configuration = this.gossipContext.getConfig();
            this.createFile(configuration.fileName());
            this.gossip = new Gossip(this.gossipContext);
            this.gossip.open();
            this.actorRef = actorScheduler.schedule((Actor)this.gossip);
        });
    }

    public void stop(ServiceStopContext stopContext) {
        this.actorRef.close();
        this.gossip.close();
    }

    public Gossip get() {
        return this.gossip;
    }

    public Injector<GossipContext> getGossipContextInjector() {
        return this.gossipContextInjector;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    private void createFile(String file) {
        File f = new File(file);
        if (!f.exists()) {
            try {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            catch (Exception e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
    }
}

