/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.gossip.service;

import io.zeebe.broker.clustering.gossip.config.GossipConfiguration;
import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.StreamUtil;
import io.zeebe.util.collection.CompactList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.agrona.concurrent.UnsafeBuffer;

public class PeerListService
implements Service<PeerList> {
    private final Injector<Peer> localPeerInjector = new Injector();
    private final GossipConfiguration config;
    private PeerList peers;

    public PeerListService(GossipConfiguration config) {
        this.config = config;
    }

    public void start(ServiceStartContext startContext) {
        Peer localPeer = (Peer)this.localPeerInjector.getValue();
        startContext.run(() -> {
            this.peers = new PeerList(this.config.peerCapacity);
            this.addStoredPeers(this.peers, this.config.fileName());
            this.addContacts(this.peers, this.config.initialContactPoints);
            this.addLocalPeer(this.peers, localPeer);
        });
    }

    public void stop(ServiceStopContext stopContext) {
        this.peers.close();
    }

    public PeerList get() {
        return this.peers;
    }

    public Injector<Peer> getLocalPeerInjector() {
        return this.localPeerInjector;
    }

    protected void addStoredPeers(PeerList peers, String path) {
        File file = new File(path);
        if (StreamUtil.canRead((File)file, (MessageDigest)StreamUtil.getSha1Digest())) {
            byte[] data = new byte[(int)file.length()];
            try (FileInputStream is2 = new FileInputStream(file);){
                StreamUtil.read((InputStream)is2, (byte[])data);
            }
            catch (IOException is2) {
                // empty catch block
            }
            UnsafeBuffer buffer = new UnsafeBuffer(data);
            CompactList underlyingList = new CompactList(buffer);
            PeerList stored = new PeerList(underlyingList);
            peers.addAll(stored);
        }
    }

    protected void addContacts(PeerList peers, String[] contacts) {
        for (int i = 0; i < contacts.length; ++i) {
            String[] parts = contacts[i].split(":");
            String host = parts[0];
            int port = this.getPort(parts[1]);
            Peer contactPoint = new Peer();
            contactPoint.managementEndpoint().host(host).port(port);
            contactPoint.heartbeat().generation(0L).version(0);
            contactPoint.state(PeerState.ALIVE);
            if (peers.find(contactPoint) >= 0) continue;
            peers.insert(contactPoint);
        }
    }

    protected void addLocalPeer(PeerList peers, Peer localPeer) {
        int idx = peers.find(localPeer);
        if (idx > -1) {
            peers.set(idx, localPeer);
        } else {
            peers.insert(localPeer);
        }
    }

    protected int getPort(String port) {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }
}

