/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.management;

import io.zeebe.broker.clustering.ClusterServiceNames;
import io.zeebe.broker.logstreams.LogStreamService;
import io.zeebe.broker.logstreams.LogStreamServiceNames;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.raft.Raft;
import io.zeebe.raft.state.RaftState;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.util.state.SimpleStateMachineContext;
import io.zeebe.util.state.State;
import io.zeebe.util.state.StateMachine;
import java.util.concurrent.CompletableFuture;

public class StartLogStreamServiceController {
    private static final int TRANSITION_DEFAULT = 0;
    private static final int TRANSITION_FAILED = 1;
    private static final int TRANSITION_OPEN = 2;
    private static final int TRANSITION_CLOSE = 3;
    private final StateMachine<Context> stateMachine;

    public StartLogStreamServiceController(Raft raft, ServiceContainer serviceContainer) {
        StartLogStreamServiceState startLogStreamService = new StartLogStreamServiceState();
        AwaitServiceFutureState awaitStartLogStreamService = new AwaitServiceFutureState();
        OpenState open = new OpenState();
        StopLogStreamServiceState stopLogStreamService = new StopLogStreamServiceState();
        AwaitServiceFutureState awaitStopLogStreamService = new AwaitServiceFutureState();
        ClosedState closed = new ClosedState();
        this.stateMachine = StateMachine.builder(s -> new Context((StateMachine<Context>)s, raft, serviceContainer)).initialState((State)closed).from((State)closed).take(2).to((State)startLogStreamService).from((State)closed).take(3).to((State)closed).from((State)startLogStreamService).take(0).to((State)awaitStartLogStreamService).from((State)awaitStartLogStreamService).take(0).to((State)open).from((State)awaitStartLogStreamService).take(1).to((State)startLogStreamService).from((State)open).take(3).to((State)stopLogStreamService).from((State)open).take(2).to((State)open).from((State)stopLogStreamService).take(0).to((State)awaitStopLogStreamService).from((State)awaitStopLogStreamService).take(0).to((State)closed).from((State)awaitStopLogStreamService).take(1).to((State)stopLogStreamService).build();
    }

    public int doWork() {
        return this.stateMachine.doWork();
    }

    public Raft getRaft() {
        return ((Context)this.stateMachine.getContext()).getRaft();
    }

    public ServiceName<LogStream> getServiceName() {
        return ((Context)this.stateMachine.getContext()).getServiceName();
    }

    static class Context
    extends SimpleStateMachineContext {
        private final Raft raft;
        private final ServiceContainer serviceContainer;
        private final ServiceName<LogStream> serviceName;
        private CompletableFuture<Void> serviceFuture;

        Context(StateMachine<Context> stateMachine, Raft raft, ServiceContainer serviceContainer) {
            super(stateMachine);
            this.raft = raft;
            this.serviceContainer = serviceContainer;
            this.serviceName = LogStreamServiceNames.logStreamServiceName(raft.getLogStream().getLogName());
            this.reset();
        }

        public void reset() {
            this.serviceFuture = null;
        }

        public Raft getRaft() {
            return this.raft;
        }

        public ServiceContainer getServiceContainer() {
            return this.serviceContainer;
        }

        public CompletableFuture<Void> getServiceFuture() {
            return this.serviceFuture;
        }

        public void setServiceFuture(CompletableFuture<Void> serviceFuture) {
            this.serviceFuture = serviceFuture;
        }

        public boolean isRaftLeader() {
            return this.raft.getState() == RaftState.LEADER && this.raft.isInitialEventCommitted();
        }

        public ServiceName<LogStream> getServiceName() {
            return this.serviceName;
        }
    }

    static class ClosedState
    implements State<Context> {
        ClosedState() {
        }

        public int doWork(Context context) throws Exception {
            int workCount = 0;
            if (context.isRaftLeader()) {
                ++workCount;
                context.take(2);
            }
            return workCount;
        }
    }

    static class StopLogStreamServiceState
    implements State<Context> {
        StopLogStreamServiceState() {
        }

        public int doWork(Context context) throws Exception {
            ServiceName<LogStream> serviceName = context.getServiceName();
            ServiceContainer serviceContainer = context.getServiceContainer();
            if (serviceContainer.hasService(serviceName)) {
                context.setServiceFuture(serviceContainer.removeService(serviceName));
            }
            context.take(0);
            return 1;
        }

        public boolean isInterruptable() {
            return false;
        }
    }

    static class OpenState
    implements State<Context> {
        OpenState() {
        }

        public int doWork(Context context) throws Exception {
            int workCount = 0;
            if (!context.isRaftLeader()) {
                ++workCount;
                context.take(3);
            }
            return workCount;
        }
    }

    static class AwaitServiceFutureState
    implements State<Context> {
        AwaitServiceFutureState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int doWork(Context context) throws Exception {
            int workCount = 0;
            CompletableFuture<Void> future = context.getServiceFuture();
            if (future != null && future.isDone()) {
                ++workCount;
                try {
                    future.get();
                    context.take(0);
                }
                catch (Throwable t) {
                    context.take(1);
                }
                finally {
                    context.setServiceFuture(null);
                }
            } else if (future == null) {
                context.take(0);
            }
            return workCount;
        }

        public boolean isInterruptable() {
            return false;
        }
    }

    static class StartLogStreamServiceState
    implements State<Context> {
        StartLogStreamServiceState() {
        }

        public int doWork(Context context) throws Exception {
            ServiceName<LogStream> serviceName = context.getServiceName();
            LogStreamService service = new LogStreamService(context.getRaft().getLogStream());
            CompletableFuture future = context.getServiceContainer().createService(serviceName, (Service)service).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE).dependency(ClusterServiceNames.CLUSTER_MANAGER_SERVICE).group(LogStreamServiceNames.LOG_STREAM_SERVICE_GROUP).install();
            context.setServiceFuture(future);
            context.take(0);
            return 1;
        }

        public boolean isInterruptable() {
            return false;
        }
    }
}

