/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.management.message;

import io.zeebe.clustering.management.InvitationRequestDecoder;
import io.zeebe.clustering.management.InvitationRequestEncoder;
import io.zeebe.clustering.management.MessageHeaderDecoder;
import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class InvitationRequest
implements BufferWriter,
BufferReader {
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final InvitationRequestDecoder bodyDecoder = new InvitationRequestDecoder();
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final InvitationRequestEncoder bodyEncoder = new InvitationRequestEncoder();
    protected DirectBuffer topicName = new UnsafeBuffer(0L, 0);
    protected int partitionId = InvitationRequestEncoder.partitionIdNullValue();
    protected int term = InvitationRequestEncoder.termNullValue();
    protected List<SocketAddress> members = new CopyOnWriteArrayList<SocketAddress>();

    public int partitionId() {
        return this.partitionId;
    }

    public InvitationRequest partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public DirectBuffer topicName() {
        return this.topicName;
    }

    public InvitationRequest topicName(DirectBuffer topicName) {
        this.topicName.wrap(topicName);
        return this;
    }

    public int term() {
        return this.term;
    }

    public InvitationRequest term(int term) {
        this.term = term;
        return this;
    }

    public List<SocketAddress> members() {
        return this.members;
    }

    public InvitationRequest members(List<SocketAddress> members) {
        this.members.clear();
        this.members.addAll(members);
        return this;
    }

    public int getLength() {
        int size = this.members.size();
        int length = this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
        length += InvitationRequestEncoder.MembersEncoder.sbeHeaderSize() + (InvitationRequestEncoder.MembersEncoder.sbeBlockLength() + InvitationRequestEncoder.MembersEncoder.hostHeaderLength()) * size;
        for (int i = 0; i < size; ++i) {
            length += this.members.get(i).hostLength();
        }
        length += InvitationRequestEncoder.topicNameHeaderLength();
        if (this.topicName != null) {
            length += this.topicName.capacity();
        }
        return length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        int size = this.members.size();
        InvitationRequestEncoder.MembersEncoder encoder = this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).partitionId(this.partitionId).term(this.term).membersCount(size);
        for (int i = 0; i < size; ++i) {
            SocketAddress member = this.members.get(i);
            encoder.next().port(member.port()).putHost((DirectBuffer)member.getHostBuffer(), 0, member.hostLength());
        }
        this.bodyEncoder.putTopicName(this.topicName, 0, this.topicName.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.partitionId = this.bodyDecoder.partitionId();
        this.term = this.bodyDecoder.term();
        this.members.clear();
        for (InvitationRequestDecoder.MembersDecoder decoder : this.bodyDecoder.members()) {
            SocketAddress member = new SocketAddress();
            member.port(decoder.port());
            MutableDirectBuffer hostBuffer = member.getHostBuffer();
            int hostLength = decoder.hostLength();
            member.hostLength(hostLength);
            decoder.getHost(hostBuffer, 0, hostLength);
            this.members.add(member);
        }
        int topicNameLength = this.bodyDecoder.topicNameLength();
        int topicNameOffset = this.bodyDecoder.limit() + InvitationRequestEncoder.topicNameHeaderLength();
        this.topicName.wrap(buffer, topicNameOffset, topicNameLength);
        this.bodyDecoder.limit(topicNameOffset + topicNameLength);
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public void reset() {
        this.topicName.wrap(0L, 0);
        this.partitionId = InvitationRequestEncoder.partitionIdNullValue();
        this.term = InvitationRequestEncoder.termNullValue();
        this.members.clear();
    }
}

