/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.management.message;

import io.zeebe.clustering.management.InvitationRequestEncoder;
import io.zeebe.clustering.management.InvitationResponseDecoder;
import io.zeebe.clustering.management.InvitationResponseEncoder;
import io.zeebe.clustering.management.MessageHeaderDecoder;
import io.zeebe.clustering.management.MessageHeaderEncoder;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class InvitationResponse
implements BufferWriter,
BufferReader {
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final InvitationResponseDecoder bodyDecoder = new InvitationResponseDecoder();
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final InvitationResponseEncoder bodyEncoder = new InvitationResponseEncoder();
    protected int term = InvitationRequestEncoder.termNullValue();

    public int term() {
        return this.term;
    }

    public InvitationResponse term(int term) {
        this.term = term;
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.term = this.bodyDecoder.term();
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).term(this.term);
    }

    public void reset() {
        this.term = InvitationRequestEncoder.termNullValue();
    }
}

