/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.management.service;

import io.zeebe.broker.clustering.gossip.data.Peer;
import io.zeebe.broker.clustering.gossip.data.PeerList;
import io.zeebe.broker.clustering.management.ClusterManagerContext;
import io.zeebe.broker.logstreams.LogStreamsManager;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ClientTransport;
import io.zeebe.util.actor.ActorScheduler;

public class ClusterManagerContextService
implements Service<ClusterManagerContext> {
    private final Injector<ClientTransport> clientTransportInjector = new Injector();
    private final Injector<BufferingServerTransport> managementApiTransportInjector = new Injector();
    private final Injector<PeerList> peerListInjector = new Injector();
    private final Injector<Peer> localPeerInjector = new Injector();
    private final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    private final Injector<LogStreamsManager> logStreamsManagerInjector = new Injector();
    private ClusterManagerContext context;

    public void start(ServiceStartContext startContext) {
        ClientTransport clientTransport = (ClientTransport)this.clientTransportInjector.getValue();
        BufferingServerTransport serverTransport = (BufferingServerTransport)this.managementApiTransportInjector.getValue();
        PeerList peers = (PeerList)this.peerListInjector.getValue();
        Peer localPeer = (Peer)this.localPeerInjector.getValue();
        ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
        LogStreamsManager logStreamsManager = (LogStreamsManager)this.logStreamsManagerInjector.getValue();
        this.context = new ClusterManagerContext();
        this.context.setActorScheduler(actorScheduler);
        this.context.setLocalPeer(localPeer);
        this.context.setClientTransport(clientTransport);
        this.context.setServerTransport(serverTransport);
        this.context.setPeers(peers);
        this.context.setLogStreamsManager(logStreamsManager);
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public ClusterManagerContext get() {
        return this.context;
    }

    public Injector<PeerList> getPeerListInjector() {
        return this.peerListInjector;
    }

    public Injector<Peer> getLocalPeerInjector() {
        return this.localPeerInjector;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public Injector<LogStreamsManager> getLogStreamsManagerInjector() {
        return this.logStreamsManagerInjector;
    }

    public Injector<BufferingServerTransport> getManagementApiTransportInjector() {
        return this.managementApiTransportInjector;
    }

    public Injector<ClientTransport> getClientTransportInjector() {
        return this.clientTransportInjector;
    }
}

