/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.management.service;

import io.zeebe.broker.clustering.management.ClusterManager;
import io.zeebe.broker.clustering.management.ClusterManagerContext;
import io.zeebe.broker.clustering.management.config.ClusterManagementConfig;
import io.zeebe.raft.Raft;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;

public class ClusterManagerService
implements Service<ClusterManager> {
    private final Injector<ClusterManagerContext> clusterManagementContextInjector = new Injector();
    private Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    private ClusterManager clusterManager;
    private ClusterManagementConfig config;
    private ServiceContainer serviceContainer;
    private ActorReference actorRef;
    private final ServiceGroupReference<Raft> raftGroupReference = ServiceGroupReference.create().onAdd((name, raft) -> this.clusterManager.addRaft((Raft)raft)).onRemove((name, raft) -> this.clusterManager.removeRaft((Raft)raft)).build();

    public ClusterManagerService(ServiceContainer serviceContainer, ClusterManagementConfig config) {
        this.serviceContainer = serviceContainer;
        this.config = config;
    }

    public void start(ServiceStartContext startContext) {
        startContext.run(() -> {
            ClusterManagerContext context = (ClusterManagerContext)this.clusterManagementContextInjector.getValue();
            ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
            this.clusterManager = new ClusterManager(context, this.serviceContainer, this.config);
            this.clusterManager.open();
            this.actorRef = actorScheduler.schedule((Actor)this.clusterManager);
        });
    }

    public void stop(ServiceStopContext stopContext) {
        this.actorRef.close();
    }

    public ClusterManager get() {
        return this.clusterManager;
    }

    public Injector<ClusterManagerContext> getClusterManagementContextInjector() {
        return this.clusterManagementContextInjector;
    }

    public ServiceGroupReference<Raft> getRaftGroupReference() {
        return this.raftGroupReference;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }
}

