/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.raft;

import io.zeebe.broker.clustering.raft.RaftConfigurationMember;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.ArrayProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.msgpack.spec.MsgPackHelper;
import io.zeebe.msgpack.value.ArrayValue;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RaftConfiguration
extends UnpackedObject {
    private static final DirectBuffer EMPTY_ARRAY = new UnsafeBuffer(MsgPackHelper.EMPTY_ARRAY);
    private static final DirectBuffer EMPTY_STRING = new UnsafeBuffer(0L, 0);
    protected StringProperty topicNameProp = new StringProperty("topicName", "");
    protected IntegerProperty partitionIdProp = new IntegerProperty("partitionId", -1);
    protected StringProperty logDirectoryProp = new StringProperty("logDirectory", "");
    protected IntegerProperty termProp = new IntegerProperty("term", 0);
    protected StringProperty votedForHostProp = new StringProperty("votedForHost", "");
    protected IntegerProperty votedForPortProp = new IntegerProperty("votedForPort", 0);
    protected ArrayProperty<RaftConfigurationMember> membersProp = new ArrayProperty("members", new ArrayValue(), new ArrayValue(EMPTY_ARRAY, 0, EMPTY_ARRAY.capacity()), (BaseValue)new RaftConfigurationMember());

    public RaftConfiguration() {
        this.declareProperty((BaseProperty)this.partitionIdProp);
        this.declareProperty((BaseProperty)this.topicNameProp);
        this.declareProperty((BaseProperty)this.logDirectoryProp);
        this.declareProperty((BaseProperty)this.termProp);
        this.declareProperty((BaseProperty)this.votedForHostProp);
        this.declareProperty((BaseProperty)this.votedForPortProp);
        this.declareProperty((BaseProperty)this.membersProp);
    }

    public DirectBuffer getTopicName() {
        return this.topicNameProp.getValue();
    }

    public void setTopicName(DirectBuffer topicName) {
        EnsureUtil.ensureGreaterThan((String)"Topic name length", (long)topicName.capacity(), (long)0L);
        this.topicNameProp.setValue(topicName, 0, topicName.capacity());
    }

    public int getPartitionId() {
        return this.partitionIdProp.getValue();
    }

    public void setPartitionId(int partitionId) {
        this.partitionIdProp.setValue(partitionId);
    }

    public String getLogDirectory() {
        return BufferUtil.bufferAsString((DirectBuffer)this.logDirectoryProp.getValue());
    }

    public void setLogDirectory(String logDirectory) {
        EnsureUtil.ensureNotNull((String)"Log directory", (Object)logDirectory);
        this.logDirectoryProp.setValue(logDirectory);
    }

    public int getTerm() {
        return this.termProp.getValue();
    }

    public void setTerm(int term) {
        this.termProp.setValue(term);
    }

    public void getVotedForHostProp(SocketAddress votedFor) {
        votedFor.reset();
        DirectBuffer votedForValue = this.votedForHostProp.getValue();
        int votedForLength = votedForValue.capacity();
        if (votedForLength > 0) {
            votedFor.host(votedForValue, 0, votedForLength);
            votedFor.port(this.votedForPortProp.getValue());
        }
    }

    public void setVotedFor(SocketAddress votedFor) {
        if (votedFor != null) {
            this.votedForHostProp.setValue((DirectBuffer)votedFor.getHostBuffer(), 0, votedFor.hostLength());
            this.votedForPortProp.setValue(votedFor.port());
        } else {
            this.votedForHostProp.setValue(EMPTY_STRING, 0, 0);
            this.votedForPortProp.setValue(-1);
        }
    }

    public List<SocketAddress> getMembers() {
        ArrayList<SocketAddress> members = new ArrayList<SocketAddress>();
        while (this.membersProp.hasNext()) {
            RaftConfigurationMember configurationMember = (RaftConfigurationMember)this.membersProp.next();
            DirectBuffer hostBuffer = configurationMember.getHost();
            SocketAddress member = new SocketAddress().host(hostBuffer, 0, hostBuffer.capacity()).port(configurationMember.getPort());
            members.add(member);
        }
        return members;
    }

    public void setMembers(List<SocketAddress> members) {
        this.membersProp.reset();
        for (int i = 0; i < members.size(); ++i) {
            this.addMember(members.get(i));
        }
    }

    public void addMember(SocketAddress member) {
        EnsureUtil.ensureNotNull((String)"Member", (Object)member);
        ((RaftConfigurationMember)this.membersProp.add()).setHost((DirectBuffer)member.getHostBuffer(), 0, member.hostLength()).setPort(member.port());
    }
}

