/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.raft;

import io.zeebe.broker.clustering.raft.RaftConfiguration;
import io.zeebe.broker.clustering.raft.RaftConfigurationMember;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.raft.RaftPersistentStorage;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.LangUtil;
import io.zeebe.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RaftPersistentFileStorage
implements RaftPersistentStorage {
    private final RaftConfiguration configuration = new RaftConfiguration();
    private final File file;
    private final File tmpFile;
    private final Path path;
    private final Path tmpPath;
    private final MutableDirectBuffer writeBuffer = new UnsafeBuffer(0L, 0);
    private final MutableDirectBuffer readBuffer = new UnsafeBuffer(0L, 0);
    private final SocketAddress votedFor = new SocketAddress();
    private LogStream logStream;

    public RaftPersistentFileStorage(String filename) {
        this.file = new File(filename);
        this.tmpFile = new File(filename + ".tmp");
        this.path = Paths.get(filename, new String[0]);
        this.tmpPath = Paths.get(filename + ".tmp", new String[0]);
        this.load();
    }

    public int getTerm() {
        return this.logStream.getTerm();
    }

    public RaftPersistentFileStorage setTerm(int term) {
        this.logStream.setTerm(term);
        this.configuration.setTerm(term);
        return this;
    }

    public SocketAddress getVotedFor() {
        if (this.votedFor.hostLength() > 0) {
            return this.votedFor;
        }
        return null;
    }

    public RaftPersistentFileStorage setVotedFor(SocketAddress votedFor) {
        this.configuration.setVotedFor(votedFor);
        if (votedFor != null) {
            this.votedFor.wrap(votedFor);
        } else {
            this.votedFor.reset();
        }
        return this;
    }

    public List<SocketAddress> getMembers() {
        ArrayList<SocketAddress> members = new ArrayList<SocketAddress>();
        while (this.configuration.membersProp.hasNext()) {
            RaftConfigurationMember member = (RaftConfigurationMember)this.configuration.membersProp.next();
            DirectBuffer hostBuffer = member.getHost();
            SocketAddress socketAddress = new SocketAddress();
            socketAddress.host(hostBuffer, 0, hostBuffer.capacity());
            socketAddress.setPort(member.getPort());
            members.add(socketAddress);
        }
        return members;
    }

    public RaftPersistentFileStorage addMember(SocketAddress member) {
        this.configuration.addMember(member);
        return this;
    }

    public RaftPersistentFileStorage clearMembers() {
        this.configuration.membersProp.reset();
        return this;
    }

    public void load() {
        if (this.file.exists()) {
            long length = this.file.length();
            if (length > (long)this.readBuffer.capacity()) {
                this.allocateReadBuffer((int)length);
            }
            try (FileInputStream is = new FileInputStream(this.file);){
                StreamUtil.read((InputStream)is, (byte[])this.readBuffer.byteArray());
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            this.configuration.wrap((DirectBuffer)this.readBuffer);
        }
    }

    public RaftPersistentFileStorage save() {
        int length = this.configuration.getEncodedLength();
        if (length > this.writeBuffer.capacity()) {
            this.allocateWriteBuffer(length);
        }
        this.configuration.write(this.writeBuffer, 0);
        try (FileOutputStream os = new FileOutputStream(this.tmpFile);){
            os.write(this.writeBuffer.byteArray(), 0, length);
            os.flush();
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        try {
            Files.move(this.tmpPath, this.path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        return this;
    }

    private void allocateWriteBuffer(int capacity) {
        this.writeBuffer.wrap(new byte[capacity]);
    }

    private void allocateReadBuffer(int capacity) {
        this.readBuffer.wrap(new byte[capacity]);
    }

    public DirectBuffer getTopicName() {
        return this.configuration.getTopicName();
    }

    public int getPartitionId() {
        return this.configuration.getPartitionId();
    }

    public String getLogDirectory() {
        return this.configuration.getLogDirectory();
    }

    public RaftPersistentFileStorage setLogStream(LogStream logStream) {
        this.logStream = logStream;
        this.configuration.setTopicName(logStream.getTopicName());
        this.configuration.setPartitionId(logStream.getPartitionId());
        logStream.setTerm(this.configuration.getTerm());
        return this;
    }

    public RaftPersistentFileStorage setLogDirectory(String logDirectory) {
        this.configuration.setLogDirectory(logDirectory);
        return this;
    }
}

