/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.raft;

import io.zeebe.logstreams.log.LogStream;
import io.zeebe.raft.Raft;
import io.zeebe.raft.RaftPersistentStorage;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class RaftService
implements Service<Raft> {
    private final SocketAddress socketAddress;
    private final LogStream logStream;
    private final List<SocketAddress> members;
    private final RaftPersistentStorage persistentStorage;
    private Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    private Injector<BufferingServerTransport> serverTransportInjector = new Injector();
    private Injector<ClientTransport> clientTransportInjector = new Injector();
    private Raft raft;
    private ActorReference actorReference;

    public RaftService(SocketAddress socketAddress, LogStream logStream, List<SocketAddress> members, RaftPersistentStorage persistentStorage) {
        this.socketAddress = socketAddress;
        this.logStream = logStream;
        this.members = members;
        this.persistentStorage = persistentStorage;
    }

    public void start(ServiceStartContext startContext) {
        CompletionStage startFuture = this.logStream.openAsync().thenAccept(v -> {
            BufferingServerTransport serverTransport = (BufferingServerTransport)this.serverTransportInjector.getValue();
            ClientTransport clientTransport = (ClientTransport)this.clientTransportInjector.getValue();
            this.raft = new Raft(this.socketAddress, this.logStream, serverTransport, clientTransport, this.persistentStorage);
            this.raft.addMembers(this.members);
            ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
            this.actorReference = actorScheduler.schedule((Actor)this.raft);
        });
        startContext.async((CompletableFuture)startFuture);
    }

    public void stop(ServiceStopContext stopContext) {
        this.actorReference.close();
        this.raft.close();
        CompletionStage stopFuture = this.logStream.closeLogStreamController().thenCompose(v -> this.logStream.closeAsync());
        stopContext.async((CompletableFuture)stopFuture);
    }

    public Raft get() {
        return this.raft;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public Injector<BufferingServerTransport> getServerTransportInjector() {
        return this.serverTransportInjector;
    }

    public Injector<ClientTransport> getClientTransportInjector() {
        return this.clientTransportInjector;
    }
}

