/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.event.processor;

import io.zeebe.broker.event.processor.TopicSubscriptionPushProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;

public class SubscriptionRegistry {
    protected SubscriptionIterator iterator = new SubscriptionIterator();
    protected final Long2ObjectHashMap<TopicSubscriptionPushProcessor> subscriptionProcessorsByKey = new Long2ObjectHashMap();
    protected final Map<DirectBuffer, TopicSubscriptionPushProcessor> subscriptionProcessorsByName = new HashMap<DirectBuffer, TopicSubscriptionPushProcessor>();

    public void addSubscription(TopicSubscriptionPushProcessor processor) {
        this.subscriptionProcessorsByKey.put(processor.getSubscriptionId(), (Object)processor);
        this.subscriptionProcessorsByName.put(processor.getName(), processor);
    }

    public TopicSubscriptionPushProcessor getProcessorByName(DirectBuffer name) {
        return this.subscriptionProcessorsByName.get(name);
    }

    public TopicSubscriptionPushProcessor removeProcessorByKey(long key) {
        TopicSubscriptionPushProcessor processor = (TopicSubscriptionPushProcessor)this.subscriptionProcessorsByKey.remove(key);
        if (processor != null) {
            this.subscriptionProcessorsByName.remove(processor.getName());
        }
        return processor;
    }

    public Iterator<TopicSubscriptionPushProcessor> iterateSubscriptions() {
        this.iterator.reset();
        return this.iterator;
    }

    protected class SubscriptionIterator
    implements Iterator<TopicSubscriptionPushProcessor> {
        protected Iterator<TopicSubscriptionPushProcessor> innerIterator;
        protected TopicSubscriptionPushProcessor currentValue = null;

        protected SubscriptionIterator() {
        }

        protected void reset() {
            this.innerIterator = SubscriptionRegistry.this.subscriptionProcessorsByKey.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public TopicSubscriptionPushProcessor next() {
            this.currentValue = this.innerIterator.next();
            return this.currentValue;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
            SubscriptionRegistry.this.subscriptionProcessorsByName.remove(this.currentValue.getName());
        }
    }
}

