/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.incident;

import io.zeebe.broker.incident.data.ErrorType;
import io.zeebe.broker.incident.data.IncidentEvent;
import io.zeebe.broker.incident.data.IncidentState;
import io.zeebe.broker.workflow.data.WorkflowInstanceEvent;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamWriter;
import io.zeebe.logstreams.log.LogStreamWriterImpl;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.processor.StreamProcessorErrorHandler;
import io.zeebe.msgpack.mapping.MappingException;
import io.zeebe.protocol.clientapi.EventType;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;

public class IncidentStreamProcessorErrorHandler
implements StreamProcessorErrorHandler {
    private final LogStream logStream;
    private final DirectBuffer sourceStreamTopicName;
    private final int sourceStreamPartitionId;
    private final LogStreamWriter logStreamWriter;
    private final BrokerEventMetadata incidentEventMetadata = new BrokerEventMetadata();
    private final IncidentEvent incidentEvent = new IncidentEvent();
    private final BrokerEventMetadata failureEventMetadata = new BrokerEventMetadata();
    private final WorkflowInstanceEvent workflowInstanceEvent = new WorkflowInstanceEvent();

    public IncidentStreamProcessorErrorHandler(LogStream logStream) {
        this.logStream = logStream;
        this.sourceStreamTopicName = logStream.getTopicName();
        this.sourceStreamPartitionId = logStream.getPartitionId();
        this.logStreamWriter = new LogStreamWriterImpl(logStream);
    }

    public boolean canHandle(Exception error) {
        return error instanceof MappingException;
    }

    public boolean onError(LoggedEvent failureEvent, Exception error) {
        boolean success = false;
        if (error instanceof MappingException) {
            success = this.handlePayloadException(failureEvent, ErrorType.IO_MAPPING_ERROR, error);
        }
        return success;
    }

    private boolean handlePayloadException(LoggedEvent failureEvent, ErrorType errorType, Exception error) {
        this.incidentEventMetadata.reset().protocolVersion(1).eventType(EventType.INCIDENT_EVENT).raftTermId(this.logStream.getTerm());
        this.incidentEvent.reset();
        this.incidentEvent.setErrorType(errorType).setErrorMessage(error.getMessage()).setFailureEventPosition(failureEvent.getPosition());
        this.failureEventMetadata.reset();
        failureEvent.readMetadata((BufferReader)this.failureEventMetadata);
        this.setWorkflowInstanceData(failureEvent);
        if (!this.failureEventMetadata.hasIncidentKey()) {
            this.incidentEvent.setState(IncidentState.CREATE);
            this.logStreamWriter.positionAsKey();
        } else {
            this.incidentEvent.setState(IncidentState.RESOLVE_FAILED);
            this.logStreamWriter.key(this.failureEventMetadata.getIncidentKey());
        }
        long position = this.logStreamWriter.producerId(70).sourceEvent(this.sourceStreamTopicName, this.sourceStreamPartitionId, failureEvent.getPosition()).metadataWriter((BufferWriter)this.incidentEventMetadata).valueWriter((BufferWriter)this.incidentEvent).tryWrite();
        return position > 0L;
    }

    private void setWorkflowInstanceData(LoggedEvent failureEvent) {
        if (this.failureEventMetadata.getEventType() != EventType.WORKFLOW_INSTANCE_EVENT) {
            throw new RuntimeException(String.format("Unsupported failure event type '%s'.", this.failureEventMetadata.getEventType().name()));
        }
        this.workflowInstanceEvent.reset();
        failureEvent.readValue((BufferReader)this.workflowInstanceEvent);
        this.incidentEvent.setBpmnProcessId(this.workflowInstanceEvent.getBpmnProcessId()).setWorkflowInstanceKey(this.workflowInstanceEvent.getWorkflowInstanceKey()).setActivityId(this.workflowInstanceEvent.getActivityId()).setActivityInstanceKey(failureEvent.getKey());
    }
}

