/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.incident.index;

import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Long2BytesZbMap;
import io.zeebe.map.ZbMap;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class IncidentMap {
    private static final int STATE_OFFSET = 0;
    private static final int INCIDENT_EVENT_POSITION_OFFSET = 2;
    private static final int FAILURE_EVENT_POSITION_OFFSET = 10;
    private static final int INDEX_VALUE_SIZE = 18;
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final byte[] rawBuffer = new byte[18];
    private final UnsafeBuffer buffer = new UnsafeBuffer(this.rawBuffer);
    private final Long2BytesZbMap map = new Long2BytesZbMap(18);
    private final ZbMapSnapshotSupport<Long2BytesZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    private long key;
    private boolean isRead = false;

    public ZbMapSnapshotSupport getSnapshotSupport() {
        return this.snapshotSupport;
    }

    public void reset() {
        this.isRead = false;
    }

    public void remove(long incidentKey) {
        this.map.remove(incidentKey, this.rawBuffer);
    }

    public IncidentMap wrapIncidentKey(long key) {
        this.isRead = this.map.get(key, this.rawBuffer);
        this.key = key;
        return this;
    }

    public short getState() {
        return this.isRead ? this.buffer.getShort(0, BYTE_ORDER) : (short)-1;
    }

    public long getIncidentEventPosition() {
        return this.isRead ? this.buffer.getLong(2, BYTE_ORDER) : -1L;
    }

    public long getFailureEventPosition() {
        return this.isRead ? this.buffer.getLong(10, BYTE_ORDER) : -1L;
    }

    public IncidentMap newIncident(long incidentKey) {
        this.key = incidentKey;
        this.isRead = true;
        return this;
    }

    public void write() {
        this.ensureRead();
        this.map.put(this.key, this.buffer.byteArray());
    }

    public IncidentMap setState(short state) {
        this.ensureRead();
        this.buffer.putShort(0, state, BYTE_ORDER);
        return this;
    }

    public IncidentMap setIncidentEventPosition(long position) {
        this.ensureRead();
        this.buffer.putLong(2, position, BYTE_ORDER);
        return this;
    }

    public IncidentMap setFailureEventPosition(long position) {
        this.ensureRead();
        this.buffer.putLong(10, position, BYTE_ORDER);
        return this;
    }

    private void ensureRead() {
        if (!this.isRead) {
            throw new IllegalStateException("must call wrap() before");
        }
    }

    public void close() {
        this.map.close();
    }
}

