/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.incident.processor;

import io.zeebe.broker.incident.data.ErrorType;
import io.zeebe.broker.incident.data.IncidentEvent;
import io.zeebe.broker.incident.data.IncidentState;
import io.zeebe.broker.incident.index.IncidentMap;
import io.zeebe.broker.logstreams.processor.MetadataFilter;
import io.zeebe.broker.task.data.TaskEvent;
import io.zeebe.broker.task.data.TaskHeaders;
import io.zeebe.broker.workflow.data.WorkflowInstanceEvent;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LogStreamWriter;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.processor.EventProcessor;
import io.zeebe.logstreams.processor.StreamProcessor;
import io.zeebe.logstreams.processor.StreamProcessorContext;
import io.zeebe.logstreams.snapshot.ComposedZbMapSnapshot;
import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.logstreams.spi.SnapshotSupport;
import io.zeebe.map.Long2LongZbMap;
import io.zeebe.map.ZbMap;
import io.zeebe.protocol.clientapi.EventType;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;

public class IncidentStreamProcessor
implements StreamProcessor {
    private static final short STATE_CREATED = 1;
    private static final short STATE_RESOLVING = 2;
    private static final short STATE_DELETING = 3;
    private static final long NON_PERSISTENT_INCIDENT = -2L;
    private final Long2LongZbMap activityInstanceMap;
    private final Long2LongZbMap failedTaskMap;
    private final IncidentMap incidentMap;
    private final SnapshotSupport indexSnapshot;
    private final CreateIncidentProcessor createIncidentProcessor = new CreateIncidentProcessor();
    private final ResolveIncidentProcessor resolveIncidentProcessor = new ResolveIncidentProcessor();
    private final ResolveFailedProcessor resolveFailedProcessor = new ResolveFailedProcessor();
    private final DeleteIncidentProcessor deleteIncidentProcessor = new DeleteIncidentProcessor();
    private final PayloadUpdatedProcessor payloadUpdatedProcessor = new PayloadUpdatedProcessor();
    private final ActivityIncidentResolvedProcessor activityIncidentResolvedProcessor = new ActivityIncidentResolvedProcessor();
    private final ActivityTerminatedProcessor activityTerminatedProcessor = new ActivityTerminatedProcessor();
    private final TaskFailedProcessor taskFailedProcessor = new TaskFailedProcessor();
    private final TaskIncidentResolvedProcessor taskIncidentResolvedProcessor = new TaskIncidentResolvedProcessor();
    private final BrokerEventMetadata sourceEventMetadata = new BrokerEventMetadata();
    private final BrokerEventMetadata targetEventMetadata = new BrokerEventMetadata();
    private final IncidentEvent incidentEvent = new IncidentEvent();
    private final WorkflowInstanceEvent workflowInstanceEvent = new WorkflowInstanceEvent();
    private final TaskEvent taskEvent = new TaskEvent();
    private long eventKey;
    private long eventPosition;
    private LogStreamReader logStreamReader;
    private LogStream targetStream;

    public IncidentStreamProcessor() {
        this.activityInstanceMap = new Long2LongZbMap();
        this.failedTaskMap = new Long2LongZbMap();
        this.incidentMap = new IncidentMap();
        this.indexSnapshot = new ComposedZbMapSnapshot(new ZbMapSnapshotSupport[]{new ZbMapSnapshotSupport((ZbMap)this.activityInstanceMap), new ZbMapSnapshotSupport((ZbMap)this.failedTaskMap), this.incidentMap.getSnapshotSupport()});
    }

    public SnapshotSupport getStateResource() {
        return this.indexSnapshot;
    }

    public void onOpen(StreamProcessorContext context) {
        this.logStreamReader = new BufferedLogStreamReader(context.getSourceStream());
        this.targetStream = context.getTargetStream();
    }

    public void onClose() {
        this.activityInstanceMap.close();
        this.failedTaskMap.close();
        this.incidentMap.close();
        this.logStreamReader.close();
    }

    public static MetadataFilter eventFilter() {
        return event -> event.getEventType() == EventType.INCIDENT_EVENT || event.getEventType() == EventType.WORKFLOW_INSTANCE_EVENT || event.getEventType() == EventType.TASK_EVENT;
    }

    public EventProcessor onEvent(LoggedEvent event) {
        this.incidentMap.reset();
        this.eventKey = event.getKey();
        this.eventPosition = event.getPosition();
        this.sourceEventMetadata.reset();
        event.readMetadata((BufferReader)this.sourceEventMetadata);
        EventProcessor eventProcessor = null;
        switch (this.sourceEventMetadata.getEventType()) {
            case INCIDENT_EVENT: {
                eventProcessor = this.onIncidentEvent(event);
                break;
            }
            case WORKFLOW_INSTANCE_EVENT: {
                eventProcessor = this.onWorkflowInstanceEvent(event);
                break;
            }
            case TASK_EVENT: {
                eventProcessor = this.onTaskEvent(event);
                break;
            }
        }
        return eventProcessor;
    }

    private EventProcessor onIncidentEvent(LoggedEvent event) {
        this.incidentEvent.reset();
        event.readValue((BufferReader)this.incidentEvent);
        switch (this.incidentEvent.getState()) {
            case CREATE: {
                return this.createIncidentProcessor;
            }
            case RESOLVE: {
                return this.resolveIncidentProcessor;
            }
            case RESOLVE_FAILED: {
                return this.resolveFailedProcessor;
            }
            case DELETE: {
                return this.deleteIncidentProcessor;
            }
        }
        return null;
    }

    private EventProcessor onWorkflowInstanceEvent(LoggedEvent event) {
        this.workflowInstanceEvent.reset();
        event.readValue((BufferReader)this.workflowInstanceEvent);
        switch (this.workflowInstanceEvent.getState()) {
            case PAYLOAD_UPDATED: {
                return this.payloadUpdatedProcessor;
            }
            case ACTIVITY_ACTIVATED: 
            case ACTIVITY_COMPLETED: {
                return this.activityIncidentResolvedProcessor;
            }
            case ACTIVITY_TERMINATED: {
                return this.activityTerminatedProcessor;
            }
        }
        return null;
    }

    private EventProcessor onTaskEvent(LoggedEvent event) {
        this.taskEvent.reset();
        event.readValue((BufferReader)this.taskEvent);
        switch (this.taskEvent.getState()) {
            case FAILED: {
                return this.taskFailedProcessor;
            }
            case RETRIES_UPDATED: 
            case CANCELED: {
                return this.taskIncidentResolvedProcessor;
            }
        }
        return null;
    }

    private long writeIncidentEvent(LogStreamWriter writer) {
        this.targetEventMetadata.reset();
        this.targetEventMetadata.eventType(EventType.INCIDENT_EVENT).protocolVersion(1).raftTermId(this.targetStream.getTerm());
        return writer.metadataWriter((BufferWriter)this.targetEventMetadata).valueWriter((BufferWriter)this.incidentEvent).tryWrite();
    }

    private LoggedEvent findEvent(long position) {
        boolean found = this.logStreamReader.seek(position);
        if (found && this.logStreamReader.hasNext()) {
            return (LoggedEvent)this.logStreamReader.next();
        }
        throw new RuntimeException("event not found");
    }

    private final class TaskIncidentResolvedProcessor
    implements EventProcessor {
        private boolean isResolved;
        private long incidentKey;

        private TaskIncidentResolvedProcessor() {
        }

        public void processEvent() {
            this.isResolved = false;
            this.incidentKey = IncidentStreamProcessor.this.failedTaskMap.get(IncidentStreamProcessor.this.eventKey, -1L);
            if (this.incidentKey > 0L) {
                IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(this.incidentKey);
                if (IncidentStreamProcessor.this.incidentMap.getState() == 1) {
                    IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.DELETE);
                    this.isResolved = true;
                } else {
                    throw new IllegalStateException("inconsistent incident map");
                }
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isResolved ? IncidentStreamProcessor.this.writeIncidentEvent(writer.key(this.incidentKey)) : 0L;
        }

        public void updateState() {
            if (this.isResolved || this.incidentKey == -2L) {
                IncidentStreamProcessor.this.failedTaskMap.remove(IncidentStreamProcessor.this.eventKey, -1L);
            }
        }
    }

    private final class TaskFailedProcessor
    implements EventProcessor {
        private boolean hasRetries;

        private TaskFailedProcessor() {
        }

        public void processEvent() {
            boolean bl = this.hasRetries = IncidentStreamProcessor.this.taskEvent.getRetries() > 0;
            if (!this.hasRetries) {
                TaskHeaders taskHeaders = IncidentStreamProcessor.this.taskEvent.headers();
                IncidentStreamProcessor.this.incidentEvent.reset();
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.CREATE).setErrorType(ErrorType.TASK_NO_RETRIES).setErrorMessage("No more retries left.").setFailureEventPosition(IncidentStreamProcessor.this.eventPosition).setBpmnProcessId(taskHeaders.getBpmnProcessId()).setWorkflowInstanceKey(taskHeaders.getWorkflowInstanceKey()).setActivityId(taskHeaders.getActivityId()).setActivityInstanceKey(taskHeaders.getActivityInstanceKey()).setTaskKey(IncidentStreamProcessor.this.eventKey);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.hasRetries ? 0L : IncidentStreamProcessor.this.writeIncidentEvent(writer.positionAsKey());
        }

        public void updateState() {
            if (!this.hasRetries) {
                IncidentStreamProcessor.this.failedTaskMap.put(IncidentStreamProcessor.this.eventKey, -2L);
            }
        }
    }

    private final class ActivityTerminatedProcessor
    implements EventProcessor {
        private boolean isTerminated;
        private long incidentKey;

        private ActivityTerminatedProcessor() {
        }

        public void processEvent() {
            this.incidentKey = IncidentStreamProcessor.this.activityInstanceMap.get(IncidentStreamProcessor.this.eventKey, -1L);
            if (this.incidentKey > 0L) {
                IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(this.incidentKey);
                if (IncidentStreamProcessor.this.incidentMap.getState() == 1 || IncidentStreamProcessor.this.incidentMap.getState() == 2) {
                    IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.DELETE);
                    this.isTerminated = true;
                } else {
                    throw new IllegalStateException("inconsistent incident map");
                }
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isTerminated ? IncidentStreamProcessor.this.writeIncidentEvent(writer.key(this.incidentKey)) : 0L;
        }

        public void updateState() {
            if (this.isTerminated) {
                IncidentStreamProcessor.this.incidentMap.setState((short)3).write();
                IncidentStreamProcessor.this.activityInstanceMap.remove(IncidentStreamProcessor.this.eventKey, -1L);
            }
        }
    }

    private final class ActivityIncidentResolvedProcessor
    implements EventProcessor {
        private boolean isResolved;
        private long incidentKey;

        private ActivityIncidentResolvedProcessor() {
        }

        public void processEvent() {
            this.isResolved = false;
            this.incidentKey = IncidentStreamProcessor.this.activityInstanceMap.get(IncidentStreamProcessor.this.eventKey, -1L);
            if (this.incidentKey > 0L) {
                IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(this.incidentKey);
                if (IncidentStreamProcessor.this.incidentMap.getState() == 2) {
                    LoggedEvent incidentCreateEvent = IncidentStreamProcessor.this.findEvent(IncidentStreamProcessor.this.incidentMap.getIncidentEventPosition());
                    IncidentStreamProcessor.this.incidentEvent.reset();
                    incidentCreateEvent.readValue((BufferReader)IncidentStreamProcessor.this.incidentEvent);
                    IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.RESOLVED);
                    this.isResolved = true;
                } else {
                    throw new IllegalStateException("inconsistent incident map");
                }
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isResolved ? IncidentStreamProcessor.this.writeIncidentEvent(writer.key(this.incidentKey)) : 0L;
        }

        public void updateState() {
            if (this.isResolved) {
                IncidentStreamProcessor.this.incidentMap.remove(this.incidentKey);
                IncidentStreamProcessor.this.activityInstanceMap.remove(IncidentStreamProcessor.this.incidentEvent.getActivityInstanceKey(), -1L);
            }
        }
    }

    private final class DeleteIncidentProcessor
    implements EventProcessor {
        private boolean isDeleted;

        private DeleteIncidentProcessor() {
        }

        public void processEvent() {
            this.isDeleted = false;
            IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(IncidentStreamProcessor.this.eventKey);
            long incidentEventPosition = IncidentStreamProcessor.this.incidentMap.getIncidentEventPosition();
            if (incidentEventPosition > 0L) {
                LoggedEvent incidentCreateEvent = IncidentStreamProcessor.this.findEvent(incidentEventPosition);
                IncidentStreamProcessor.this.incidentEvent.reset();
                incidentCreateEvent.readValue((BufferReader)IncidentStreamProcessor.this.incidentEvent);
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.DELETED);
                this.isDeleted = true;
            } else {
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.DELETE_REJECTED);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return IncidentStreamProcessor.this.writeIncidentEvent(writer.key(IncidentStreamProcessor.this.eventKey));
        }

        public void updateState() {
            if (this.isDeleted) {
                IncidentStreamProcessor.this.incidentMap.remove(IncidentStreamProcessor.this.eventKey);
            }
        }
    }

    private final class ResolveFailedProcessor
    implements EventProcessor {
        private boolean isFailed;

        private ResolveFailedProcessor() {
        }

        public void processEvent() {
            IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(IncidentStreamProcessor.this.eventKey);
            this.isFailed = IncidentStreamProcessor.this.incidentMap.getState() == 2;
        }

        public void updateState() {
            if (this.isFailed) {
                IncidentStreamProcessor.this.incidentMap.setState((short)1).write();
            }
        }
    }

    private final class ResolveIncidentProcessor
    implements EventProcessor {
        private boolean isResolved;
        private LoggedEvent failureEvent;

        private ResolveIncidentProcessor() {
        }

        public void processEvent() {
            this.isResolved = false;
            IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(IncidentStreamProcessor.this.eventKey);
            if (IncidentStreamProcessor.this.incidentMap.getState() == 1) {
                this.failureEvent = IncidentStreamProcessor.this.findEvent(IncidentStreamProcessor.this.incidentMap.getFailureEventPosition());
                IncidentStreamProcessor.this.workflowInstanceEvent.reset();
                this.failureEvent.readValue((BufferReader)IncidentStreamProcessor.this.workflowInstanceEvent);
                IncidentStreamProcessor.this.workflowInstanceEvent.setPayload(IncidentStreamProcessor.this.incidentEvent.getPayload());
                this.isResolved = true;
            } else {
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.RESOLVE_REJECTED);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            long position = 0L;
            if (this.isResolved) {
                IncidentStreamProcessor.this.targetEventMetadata.reset();
                this.failureEvent.readMetadata((BufferReader)IncidentStreamProcessor.this.targetEventMetadata);
                IncidentStreamProcessor.this.targetEventMetadata.incidentKey(IncidentStreamProcessor.this.eventKey).protocolVersion(1).raftTermId(IncidentStreamProcessor.this.targetStream.getTerm());
                position = writer.key(this.failureEvent.getKey()).metadataWriter((BufferWriter)IncidentStreamProcessor.this.targetEventMetadata).valueWriter((BufferWriter)IncidentStreamProcessor.this.workflowInstanceEvent).tryWrite();
            } else {
                position = IncidentStreamProcessor.this.writeIncidentEvent(writer.key(IncidentStreamProcessor.this.eventKey));
            }
            return position;
        }

        public void updateState() {
            if (this.isResolved) {
                IncidentStreamProcessor.this.incidentMap.setState((short)2).write();
            }
        }
    }

    private final class PayloadUpdatedProcessor
    implements EventProcessor {
        private boolean isResolving;
        private long incidentKey;

        private PayloadUpdatedProcessor() {
        }

        public void processEvent() {
            this.isResolving = false;
            this.incidentKey = IncidentStreamProcessor.this.activityInstanceMap.get(IncidentStreamProcessor.this.eventKey, -1L);
            if (this.incidentKey > 0L && IncidentStreamProcessor.this.incidentMap.wrapIncidentKey(this.incidentKey).getState() == 1) {
                IncidentStreamProcessor.this.incidentEvent.reset();
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.RESOLVE).setWorkflowInstanceKey(IncidentStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).setActivityInstanceKey(IncidentStreamProcessor.this.eventKey).setPayload(IncidentStreamProcessor.this.workflowInstanceEvent.getPayload());
                this.isResolving = true;
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isResolving ? IncidentStreamProcessor.this.writeIncidentEvent(writer.key(this.incidentKey)) : 0L;
        }
    }

    private final class CreateIncidentProcessor
    implements EventProcessor {
        private boolean isCreated;
        private boolean isTaskIncident;

        private CreateIncidentProcessor() {
        }

        public void processEvent() {
            boolean bl = this.isTaskIncident = IncidentStreamProcessor.this.incidentEvent.getTaskKey() > 0L;
            boolean bl2 = this.isTaskIncident ? IncidentStreamProcessor.this.failedTaskMap.get(IncidentStreamProcessor.this.incidentEvent.getTaskKey(), -1L) == -2L : (this.isCreated = true);
            if (this.isCreated) {
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.CREATED);
            } else {
                IncidentStreamProcessor.this.incidentEvent.setState(IncidentState.CREATE_REJECTED);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return IncidentStreamProcessor.this.writeIncidentEvent(writer.key(IncidentStreamProcessor.this.eventKey));
        }

        public void updateState() {
            if (this.isCreated) {
                IncidentStreamProcessor.this.incidentMap.newIncident(IncidentStreamProcessor.this.eventKey).setState((short)1).setIncidentEventPosition(IncidentStreamProcessor.this.eventPosition).setFailureEventPosition(IncidentStreamProcessor.this.incidentEvent.getFailureEventPosition()).write();
                if (this.isTaskIncident) {
                    IncidentStreamProcessor.this.failedTaskMap.put(IncidentStreamProcessor.this.incidentEvent.getTaskKey(), IncidentStreamProcessor.this.eventKey);
                } else {
                    IncidentStreamProcessor.this.activityInstanceMap.put(IncidentStreamProcessor.this.incidentEvent.getActivityInstanceKey(), IncidentStreamProcessor.this.eventKey);
                }
            }
        }
    }
}

