/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams;

import io.zeebe.broker.event.TopicSubscriptionServiceNames;
import io.zeebe.broker.event.processor.TopicSubscriptionService;
import io.zeebe.broker.logstreams.LogStreamServiceNames;
import io.zeebe.broker.logstreams.LogStreamsManagerService;
import io.zeebe.broker.logstreams.SnapshotStorageService;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.servicecontainer.Service;

public class LogStreamsComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        LogStreamsManagerService streamsManager = new LogStreamsManagerService(context.getConfigurationManager());
        context.getServiceContainer().createService(LogStreamServiceNames.LOG_STREAMS_MANAGER_SERVICE, (Service)streamsManager).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, streamsManager.getActorSchedulerInjector()).install();
        SnapshotStorageService snapshotStorageService = new SnapshotStorageService(context.getConfigurationManager());
        context.getServiceContainer().createService(LogStreamServiceNames.SNAPSHOT_STORAGE_SERVICE, (Service)snapshotStorageService).install();
        TopicSubscriptionService topicSubscriptionService = new TopicSubscriptionService(context.getConfigurationManager());
        context.getServiceContainer().createService(TopicSubscriptionServiceNames.TOPIC_SUBSCRIPTION_SERVICE, (Service)topicSubscriptionService).dependency(TransportServiceNames.serverTransport("clientApi.server"), topicSubscriptionService.getClientApiTransportInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, topicSubscriptionService.getActorSchedulerInjector()).groupReference(LogStreamServiceNames.LOG_STREAM_SERVICE_GROUP, topicSubscriptionService.getLogStreamsGroupReference()).install();
    }
}

