/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams;

import io.zeebe.broker.logstreams.cfg.LogStreamsCfg;
import io.zeebe.logstreams.LogStreams;
import io.zeebe.logstreams.fs.FsLogStreamBuilder;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.actor.ActorScheduler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class LogStreamsManager {
    protected LogStreamsCfg logStreamsCfg;
    protected ActorScheduler actorScheduler;
    protected Map<DirectBuffer, Int2ObjectHashMap<LogStream>> logStreams;

    public LogStreamsManager(LogStreamsCfg logStreamsCfg, ActorScheduler actorScheduler) {
        this.logStreamsCfg = logStreamsCfg;
        this.actorScheduler = actorScheduler;
        this.logStreams = new HashMap<DirectBuffer, Int2ObjectHashMap<LogStream>>();
    }

    public void forEachLogStream(Consumer<LogStream> consumer) {
        this.logStreams.forEach((topicName, partitions) -> partitions.forEach((partitionId, logStream) -> consumer.accept((LogStream)logStream)));
    }

    public LogStream getLogStream(DirectBuffer topicName, int partitionId) {
        Int2ObjectHashMap<LogStream> logStreamPartitions = this.logStreams.get(topicName);
        if (logStreamPartitions != null) {
            return (LogStream)logStreamPartitions.get(partitionId);
        }
        return null;
    }

    public LogStream createLogStream(DirectBuffer topicName, int partitionId) {
        EnsureUtil.ensureNotNullOrEmpty((String)"topic name", (DirectBuffer)topicName);
        EnsureUtil.ensureGreaterThanOrEqual((String)"partition id", (long)partitionId, (long)0L);
        EnsureUtil.ensureLessThanOrEqual((String)"partition id", (long)partitionId, (long)32767L);
        FsLogStreamBuilder logStreamBuilder = LogStreams.createFsLogStream((DirectBuffer)topicName, (int)partitionId);
        String logName = logStreamBuilder.getLogName();
        boolean deleteOnExit = false;
        int assignedLogDirectory = 0;
        if (this.logStreamsCfg.directories.length == 0) {
            throw new RuntimeException(String.format("Cannot start log %s, no log directory provided.", logName));
        }
        if (this.logStreamsCfg.directories.length > 1) {
            assignedLogDirectory = new Random().nextInt(this.logStreamsCfg.directories.length - 1);
        }
        String logDirectory = this.logStreamsCfg.directories[assignedLogDirectory] + File.separator + logName;
        int logSegmentSize = this.logStreamsCfg.defaultLogSegmentSize * 1024 * 1024;
        LogStream logStream = ((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)logStreamBuilder.deleteOnClose(false)).logDirectory(logDirectory)).actorScheduler(this.actorScheduler)).logSegmentSize(logSegmentSize)).logStreamControllerDisabled(true)).build();
        this.addLogStream(logStream);
        return logStream;
    }

    public LogStream createLogStream(DirectBuffer topicName, int partitionId, String logDirectory) {
        LogStream logStream = ((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)((FsLogStreamBuilder)LogStreams.createFsLogStream((DirectBuffer)topicName, (int)partitionId).deleteOnClose(false)).logDirectory(logDirectory)).actorScheduler(this.actorScheduler)).logSegmentSize(this.logStreamsCfg.defaultLogSegmentSize * 1024 * 1024)).logStreamControllerDisabled(true)).build();
        this.addLogStream(logStream);
        return logStream;
    }

    private void addLogStream(LogStream logStream) {
        this.logStreams.computeIfAbsent(logStream.getTopicName(), k -> new Int2ObjectHashMap()).put(logStream.getPartitionId(), (Object)logStream);
    }
}

