/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams;

import io.zeebe.broker.logstreams.LogStreamsManager;
import io.zeebe.broker.logstreams.cfg.LogStreamsCfg;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.actor.ActorScheduler;

public class LogStreamsManagerService
implements Service<LogStreamsManager> {
    protected final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    protected LogStreamsCfg logStreamsCfg;
    protected LogStreamsManager service;

    public LogStreamsManagerService(ConfigurationManager configurationManager) {
        this.logStreamsCfg = configurationManager.readEntry("logs", LogStreamsCfg.class);
    }

    public void start(ServiceStartContext serviceContext) {
        serviceContext.run(() -> {
            this.service = new LogStreamsManager(this.logStreamsCfg, (ActorScheduler)this.actorSchedulerInjector.getValue());
            this.service.createLogStream(LogStream.DEFAULT_TOPIC_NAME_BUFFER, 0);
        });
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public LogStreamsManager get() {
        return this.service;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }
}

