/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams;

import io.zeebe.broker.logstreams.cfg.SnapshotStorageCfg;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.logstreams.LogStreams;
import io.zeebe.logstreams.spi.SnapshotStorage;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;

public class SnapshotStorageService
implements Service<SnapshotStorage> {
    protected SnapshotStorageCfg config;
    private SnapshotStorage snapshotStorage;

    public SnapshotStorageService(ConfigurationManager configurationManager) {
        this.config = configurationManager.readEntry("snapshot", SnapshotStorageCfg.class);
    }

    public void start(ServiceStartContext serviceContext) {
        serviceContext.run(() -> {
            String snapshotDirectory = this.config.directory;
            this.snapshotStorage = LogStreams.createFsSnapshotStore((String)snapshotDirectory).build();
        });
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public SnapshotStorage get() {
        return this.snapshotStorage;
    }
}

