/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.services;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.services.Counters;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.metrics.cfg.MetricsCfg;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.BitUtil;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.slf4j.Logger;

public class CountersManagerService
implements Service<Counters> {
    public static final Logger LOG = Loggers.SERVICES_LOGGER;
    public static final int COUNTERS_FILE_SIZE = 0x400000;
    public static final int LABELS_BUFFER_OFFSET = 0;
    public static final int LABELS_BUFFER_SIZE = 0x300000;
    public static final int COUNTERS_BUFFER_OFFSET = BitUtil.align((int)0x300000, (int)8);
    public static final int COUNTERS_BUFFER_SIZE = 0x400000 - COUNTERS_BUFFER_OFFSET;
    public static final String COUNTERS_FILE_NAME = "metrics.zeebe";
    protected final String countersFileName;
    protected CountersManager countersManager;
    protected MappedByteBuffer mappedCountersFile;
    protected Counters counters;

    public CountersManagerService(ConfigurationManager configurationManager) {
        MetricsCfg metricsCfg = configurationManager.readEntry("metrics", MetricsCfg.class);
        this.countersFileName = metricsCfg.directory + COUNTERS_FILE_NAME;
    }

    public void start(ServiceStartContext ctx) {
        ctx.run(() -> {
            File countersFile = new File(this.countersFileName);
            countersFile.mkdirs();
            LOG.info("Using {} for counters", (Object)countersFile.getAbsolutePath());
            IoUtil.deleteIfExists((File)countersFile);
            this.mappedCountersFile = IoUtil.mapNewFile((File)countersFile, (long)0x400000L);
            UnsafeBuffer labelsBuffer = new UnsafeBuffer((ByteBuffer)this.mappedCountersFile, 0, 0x300000);
            UnsafeBuffer countersBuffer = new UnsafeBuffer((ByteBuffer)this.mappedCountersFile, COUNTERS_BUFFER_OFFSET, COUNTERS_BUFFER_SIZE);
            this.countersManager = new CountersManager((AtomicBuffer)labelsBuffer, (AtomicBuffer)countersBuffer);
            this.counters = new Counters(this.countersManager, (AtomicBuffer)countersBuffer);
        });
    }

    public void stop(ServiceStopContext ctx) {
        ctx.run(() -> {
            this.countersManager.forEach((id, label) -> {
                LOG.error("Freeing counter {}", label);
                this.countersManager.free(id);
            });
            IoUtil.unmap((MappedByteBuffer)this.mappedCountersFile);
        });
    }

    public Counters get() {
        return this.counters;
    }
}

