/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.services;

import io.zeebe.broker.services.Counters;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.DispatcherBuilder;
import io.zeebe.dispatcher.Dispatchers;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class DispatcherService
implements Service<Dispatcher> {
    protected final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    protected final Injector<Counters> countersInjector = new Injector();
    protected DispatcherBuilder dispatcherBuilder;
    protected Dispatcher dispatcher;
    protected ActorReference conductorRef;

    public DispatcherService(int bufferSize) {
        this(Dispatchers.create(null).bufferSize(bufferSize));
    }

    public DispatcherService(DispatcherBuilder builder) {
        this.dispatcherBuilder = builder;
    }

    public void start(ServiceStartContext ctx) {
        Counters counters = (Counters)this.countersInjector.getValue();
        this.dispatcher = this.dispatcherBuilder.name(ctx.getName()).conductorExternallyManaged().countersManager(counters.getCountersManager()).countersBuffer(counters.getCountersBuffer()).build();
        this.conductorRef = ((ActorScheduler)this.actorSchedulerInjector.getValue()).schedule(this.dispatcher.getConductor());
    }

    public void stop(ServiceStopContext ctx) {
        CompletionStage closeFuture = this.dispatcher.closeAsync().thenAccept(v -> this.conductorRef.close());
        ctx.async((CompletableFuture)closeFuture);
    }

    public Dispatcher get() {
        return this.dispatcher;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public Injector<Counters> getCountersManagerInjector() {
        return this.countersInjector;
    }
}

