/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import com.moandjiezana.toml.Toml;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.ComponentConfiguration;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.GlobalConfiguration;
import io.zeebe.util.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    protected Toml toml;
    protected GlobalConfiguration globalConfiguration;

    public ConfigurationManagerImpl(String filePath) {
        if (filePath == null) {
            this.initDefault();
        } else {
            File file = new File(filePath);
            LOG.info("Using config file " + file.getAbsolutePath());
            this.toml = new Toml().read(file);
        }
        this.initGlobalConfiguration();
    }

    public ConfigurationManagerImpl(InputStream configStream) {
        if (configStream == null) {
            this.initDefault();
        } else {
            LOG.info("Using provided configuration stream");
            this.toml = new Toml().read(configStream);
        }
        this.initGlobalConfiguration();
    }

    public void initDefault() {
        LOG.info("No configuration provided, using default configuration.");
        try (InputStream resourceAsStream = ConfigurationManagerImpl.class.getClassLoader().getResourceAsStream("zeebe.default.cfg.toml");){
            this.toml = new Toml().read(resourceAsStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read configuration", e);
        }
    }

    private void initGlobalConfiguration() {
        this.globalConfiguration = this.createConfiguration("global", GlobalConfiguration.class);
        this.globalConfiguration.init();
    }

    @Override
    public <T> T readEntry(String key, Class<T> configurationType) {
        T configuration = this.createConfiguration(key, configurationType);
        this.applyGlobalConfiguration(configuration);
        return configuration;
    }

    @Override
    public <T> List<T> readList(String key, Class<T> type) {
        ArrayList result = new ArrayList();
        List tables = this.toml.getTables(key);
        if (tables != null) {
            for (Toml toml : tables) {
                Object configObject = toml.to(type);
                this.applyGlobalConfiguration(configObject);
            }
        }
        return result;
    }

    private <T> T createConfiguration(String key, Class<T> configurationType) {
        Toml componentConfig = this.toml.getTable(key);
        Object configObject = componentConfig != null ? componentConfig.to(configurationType) : ReflectUtil.newInstance(configurationType);
        return (T)configObject;
    }

    private <T> void applyGlobalConfiguration(T configuration) {
        if (configuration instanceof ComponentConfiguration) {
            ComponentConfiguration componentConfig = (ComponentConfiguration)configuration;
            componentConfig.applyGlobalConfiguration(this.globalConfiguration);
        }
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }
}

