/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.zeebe.broker.system.ComponentConfiguration;
import io.zeebe.broker.system.GlobalConfiguration;
import io.zeebe.util.FileUtil;
import java.io.File;

public abstract class DirectoryConfiguration
extends ComponentConfiguration {
    private static final String SUB_DIRECTORY_NAME_PATTERN = "%s" + File.separator + "%s";
    public String directory;

    @Override
    public void applyGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        String localDirectory = this.directory;
        if (localDirectory == null || localDirectory.isEmpty()) {
            String globalDirectory = globalConfiguration.directory;
            String subDirectory = this.componentDirectoryName();
            localDirectory = subDirectory != null && !subDirectory.isEmpty() ? String.format(SUB_DIRECTORY_NAME_PATTERN, globalDirectory, subDirectory) : globalDirectory;
        }
        this.directory = FileUtil.getCanonicalPath((String)localDirectory);
    }

    protected String componentDirectoryName() {
        return null;
    }

    public String getDirectory() {
        return this.directory;
    }
}

