/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.DirectoryConfiguration;
import io.zeebe.util.FileUtil;
import java.io.File;
import org.slf4j.Logger;

public class GlobalConfiguration
extends DirectoryConfiguration {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    public static final String GLOBAL_DIRECTORY_DEFAULT = "./data";
    public static final String GLOBAL_DIRECTORY_TEMP = "zeebe-data-";
    public boolean useTempDirectory;

    public void init() {
        if (this.directory == null || this.directory.isEmpty()) {
            if (!this.useTempDirectory) {
                this.directory = GLOBAL_DIRECTORY_DEFAULT;
            } else {
                File tmp = FileUtil.createTempDirectory((String)GLOBAL_DIRECTORY_TEMP);
                this.directory = tmp.toString();
            }
        } else if (this.useTempDirectory) {
            throw new RuntimeException("Can't use attribute 'directory' and element 'useTempDirectory' together as global configuration, only use one.");
        }
        this.directory = FileUtil.getCanonicalPath((String)this.directory);
        LOG.info("Using data directory: {}", (Object)this.directory);
    }

    public boolean isTempDirectory() {
        return this.useTempDirectory;
    }
}

