/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.zeebe.broker.services.CountersManagerService;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.system.executor.ScheduledExecutorService;
import io.zeebe.broker.system.threads.ActorSchedulerService;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;

public class SystemComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        ServiceContainer serviceContainer = context.getServiceContainer();
        CountersManagerService countersManagerService = new CountersManagerService(context.getConfigurationManager());
        serviceContainer.createService(SystemServiceNames.COUNTERS_MANAGER_SERVICE, (Service)countersManagerService).install();
        ActorSchedulerService agentRunnerService = new ActorSchedulerService(context.getConfigurationManager());
        serviceContainer.createService(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, (Service)agentRunnerService).install();
        ScheduledExecutorService executorService = new ScheduledExecutorService();
        serviceContainer.createService(SystemServiceNames.EXECUTOR_SERVICE, (Service)executorService).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, executorService.getActorSchedulerInjector()).install();
    }
}

