/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.ConfigurationManagerImpl;
import io.zeebe.broker.system.GlobalConfiguration;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.impl.ServiceContainerImpl;
import io.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public class SystemContext
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    protected final ServiceContainer serviceContainer;
    protected final List<Component> components = new ArrayList<Component>();
    protected final ConfigurationManager configurationManager;
    protected final List<CompletableFuture<?>> requiredStartActions = new ArrayList();

    protected SystemContext(ConfigurationManager configurationManager) {
        this.serviceContainer = new ServiceContainerImpl();
        this.configurationManager = configurationManager;
    }

    public SystemContext(String configFileLocation) {
        this(new ConfigurationManagerImpl(configFileLocation));
    }

    public SystemContext(InputStream configStream) {
        this(new ConfigurationManagerImpl(configStream));
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void init() {
        this.serviceContainer.start();
        for (Component brokerComponent : this.components) {
            try {
                brokerComponent.init(this);
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        }
        try {
            CompletableFuture[] startActions = this.requiredStartActions.toArray(new CompletableFuture[this.requiredStartActions.size()]);
            CompletableFuture.allOf(startActions).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Could not start broker", (Throwable)e);
            this.close();
            LangUtil.rethrowUnchecked((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.info("Closing...");
        try {
            this.serviceContainer.close(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LOG.error("Failed to close broker within 10 seconds", (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Exception while closing broker", (Throwable)e);
        }
        finally {
            GlobalConfiguration config = this.configurationManager.getGlobalConfiguration();
            String directory = config.getDirectory();
            if (config.isTempDirectory()) {
                try {
                    FileUtil.deleteFolder((String)directory);
                }
                catch (IOException e) {
                    LOG.error("Exception while deleting temp folder", (Throwable)e);
                }
            }
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void addRequiredStartAction(CompletableFuture<?> future) {
        this.requiredStartActions.add(future);
    }
}

