/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.threads;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.threads.cfg.ThreadingCfg;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.actor.ActorScheduler;
import io.zeebe.util.actor.ActorSchedulerBuilder;
import java.util.concurrent.TimeUnit;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.slf4j.Logger;

public class ActorSchedulerService
implements Service<ActorScheduler> {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    static int maxThreadCount = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    protected final int availableThreads;
    protected final ThreadingCfg.BrokerIdleStrategy brokerIdleStrategy;
    protected final int maxIdleTimeMs;
    protected ActorScheduler scheduler;

    public ActorSchedulerService(ConfigurationManager configurationManager) {
        ThreadingCfg cfg = configurationManager.readEntry("threading", ThreadingCfg.class);
        int numberOfThreads = cfg.numberOfThreads;
        if (numberOfThreads > maxThreadCount) {
            LOG.warn("Configured thread count {} is larger than maxThreadCount {}. Falling back max thread count.", (Object)numberOfThreads, (Object)maxThreadCount);
            numberOfThreads = maxThreadCount;
        } else if (numberOfThreads < 1) {
            numberOfThreads = maxThreadCount;
        }
        this.availableThreads = numberOfThreads;
        this.brokerIdleStrategy = cfg.idleStrategy;
        this.maxIdleTimeMs = cfg.maxIdleTimeMs;
    }

    public void start(ServiceStartContext serviceContext) {
        IdleStrategy idleStrategy = this.createIdleStrategy(this.brokerIdleStrategy);
        ErrorHandler errorHandler = t -> t.printStackTrace();
        this.scheduler = new ActorSchedulerBuilder().name("broker").threadCount(this.availableThreads).runnerIdleStrategy(idleStrategy).runnerErrorHander(errorHandler).baseIterationsPerActor(37).build();
    }

    public void stop(ServiceStopContext stopContext) {
        try {
            this.scheduler.close();
        }
        catch (Exception e) {
            LOG.error("Unable to stop actor scheduler", (Throwable)e);
        }
    }

    public ActorScheduler get() {
        return this.scheduler;
    }

    protected IdleStrategy createIdleStrategy(ThreadingCfg.BrokerIdleStrategy idleStrategy) {
        switch (idleStrategy) {
            case BUSY_SPIN: {
                return new BusySpinIdleStrategy();
            }
        }
        return new BackoffIdleStrategy(1000L, 100L, 100L, TimeUnit.MILLISECONDS.toNanos(this.maxIdleTimeMs));
    }
}

