/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.task;

import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.collection.CompactList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.OneToOneRingBuffer;

public class CreditsRequest
implements BufferReader {
    protected static final int LENGTH = 12;
    protected static final int TYPE = 42;
    protected UnsafeBuffer content = new UnsafeBuffer(new byte[12]);

    public CreditsRequest() {
    }

    public CreditsRequest(long subscriberKey, int credits) {
        this.setSubscriberKey(subscriberKey);
        this.setCredits(credits);
    }

    public void wrap(DirectBuffer buffer, int index, int length) {
        if (length != 12) {
            throw new RuntimeException("Unexpected message length");
        }
        this.content.putBytes(0, buffer, index, length);
    }

    public long getSubscriberKey() {
        return this.content.getLong(0);
    }

    public void setSubscriberKey(long subscriberKey) {
        this.content.putLong(0, subscriberKey);
    }

    public int getCredits() {
        return this.content.getInt(8);
    }

    public void setCredits(int credits) {
        this.content.putInt(8, credits);
    }

    public boolean writeTo(OneToOneRingBuffer ringBuffer) {
        return ringBuffer.write(42, (DirectBuffer)this.content, 0, 12);
    }

    public void appendTo(CompactList list) {
        list.add((DirectBuffer)this.content);
    }

    public void wrapListElement(CompactList list, int index) {
        list.wrap(index, (MutableDirectBuffer)this.content);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreditsRequest) || obj == null) {
            return false;
        }
        CreditsRequest request = (CreditsRequest)obj;
        return request.content.equals((Object)this.content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }
}

