/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.task;

import io.zeebe.broker.task.CreditsRequest;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.OneToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class CreditsRequestBuffer {
    protected final int capacityUpperBound;
    protected final OneToOneRingBuffer ringBuffer;
    protected final RequestHandler requestHandler;

    public CreditsRequestBuffer(int capacityLowerBound, Consumer<CreditsRequest> requestConsumer) {
        int bufferCapacity = CreditsRequestBuffer.requiredBufferCapacityForNumRequests(capacityLowerBound, 12);
        this.capacityUpperBound = CreditsRequestBuffer.numRequestsFittingInto(bufferCapacity, 12);
        UnsafeBuffer rawBuffer = new UnsafeBuffer(new byte[bufferCapacity]);
        this.ringBuffer = new OneToOneRingBuffer((AtomicBuffer)rawBuffer);
        this.requestHandler = new RequestHandler(requestConsumer);
    }

    protected static int requiredBufferCapacityForNumRequests(int numRequests, int requestLength) {
        int recordLength = 8 + requestLength;
        int allRecordsLength = numRequests * recordLength;
        return BitUtil.findNextPositivePowerOfTwo((int)allRecordsLength) + RingBufferDescriptor.TRAILER_LENGTH;
    }

    protected static int numRequestsFittingInto(int bufferSize, int requestLength) {
        int recordLength = 8 + requestLength;
        return (bufferSize - RingBufferDescriptor.TRAILER_LENGTH) / recordLength;
    }

    public int handleRequests() {
        return this.ringBuffer.read((MessageHandler)this.requestHandler);
    }

    public boolean offerRequest(CreditsRequest request) {
        return request.writeTo(this.ringBuffer);
    }

    public int getCapacityUpperBound() {
        return this.capacityUpperBound;
    }

    protected static class RequestHandler
    implements MessageHandler {
        protected final CreditsRequest request = new CreditsRequest();
        protected final Consumer<CreditsRequest> requestConsumer;

        public RequestHandler(Consumer<CreditsRequest> requestConsumer) {
            this.requestConsumer = requestConsumer;
        }

        public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
            this.request.wrap((DirectBuffer)buffer, index, length);
            this.requestConsumer.accept(this.request);
        }
    }
}

