/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.task;

import io.zeebe.broker.task.TaskSubscriptionManager;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.TransportListener;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;
import java.util.concurrent.CompletableFuture;

public class TaskSubscriptionManagerService
implements Service<TaskSubscriptionManager> {
    protected final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    protected final Injector<ServerTransport> transportInjector = new Injector();
    protected TaskSubscriptionManager service;
    protected ActorReference actorRef;
    protected final ServiceGroupReference<LogStream> logStreamsGroupReference = ServiceGroupReference.create().onAdd((name, stream) -> this.service.addStream((LogStream)stream, (ServiceName<LogStream>)name)).onRemove((name, stream) -> this.service.removeStream((LogStream)stream)).build();

    public void start(ServiceStartContext startContext) {
        ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
        this.service = new TaskSubscriptionManager(startContext);
        this.actorRef = actorScheduler.schedule((Actor)this.service);
        ServerTransport clientApiTransport = (ServerTransport)this.transportInjector.getValue();
        CompletableFuture transportRegistration = clientApiTransport.registerChannelListener((TransportListener)this.service);
        startContext.async(transportRegistration);
    }

    public void stop(ServiceStopContext stopContext) {
        this.actorRef.close();
    }

    public TaskSubscriptionManager get() {
        return this.service;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public ServiceGroupReference<LogStream> getLogStreamsGroupReference() {
        return this.logStreamsGroupReference;
    }

    public Injector<ServerTransport> getClientApiTransportInjector() {
        return this.transportInjector;
    }
}

