/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.task.map;

import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Long2BytesZbMap;
import io.zeebe.map.ZbMap;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class TaskInstanceMap {
    private static final int MAP_VALUE_SIZE = 134;
    private static final int STATE_OFFSET = 0;
    private static final int LOCK_OWNER_LENGTH_OFFSET = 2;
    private static final int LOCK_OWNER_OFFSET = 6;
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final byte[] rawBuffer = new byte[134];
    private final UnsafeBuffer buffer = new UnsafeBuffer(this.rawBuffer);
    private final UnsafeBuffer lockOwnerBuffer = new UnsafeBuffer(0L, 0);
    private final Long2BytesZbMap map = new Long2BytesZbMap(134);
    private final ZbMapSnapshotSupport<Long2BytesZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    private long key;
    private boolean isRead = false;

    public ZbMapSnapshotSupport<Long2BytesZbMap> getSnapshotSupport() {
        return this.snapshotSupport;
    }

    public void reset() {
        this.isRead = false;
    }

    public void remove(long workflowInstanceKey) {
        this.map.remove(workflowInstanceKey, this.rawBuffer);
    }

    public TaskInstanceMap wrapTaskInstanceKey(long key) {
        this.isRead = this.map.get(key, this.rawBuffer);
        this.key = key;
        return this;
    }

    public short getState() {
        return this.isRead ? this.buffer.getShort(0, BYTE_ORDER) : (short)-1;
    }

    public DirectBuffer getLockOwner() {
        if (this.isRead) {
            int length = this.buffer.getInt(2, BYTE_ORDER);
            this.lockOwnerBuffer.wrap((DirectBuffer)this.buffer, 6, length);
        } else {
            this.lockOwnerBuffer.wrap(0L, 0);
        }
        return this.lockOwnerBuffer;
    }

    public TaskInstanceMap newTaskInstance(long taskInstanceKey) {
        this.key = taskInstanceKey;
        this.isRead = true;
        return this;
    }

    public void write() {
        this.ensureRead();
        this.map.put(this.key, this.buffer.byteArray());
    }

    public TaskInstanceMap setState(short state) {
        this.ensureRead();
        this.buffer.putShort(0, state, BYTE_ORDER);
        return this;
    }

    public TaskInstanceMap setLockOwner(DirectBuffer lockOwner) {
        this.ensureRead();
        this.buffer.putInt(2, lockOwner.capacity(), BYTE_ORDER);
        this.buffer.putBytes(6, lockOwner, 0, lockOwner.capacity());
        return this;
    }

    private void ensureRead() {
        if (!this.isRead) {
            throw new IllegalStateException("must call wrapTaskInstanceKey() before");
        }
    }

    public void close() {
        this.map.close();
    }
}

