/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.broker.Loggers;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.Transports;
import io.zeebe.util.actor.ActorScheduler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public class BufferingServerTransportService
implements Service<BufferingServerTransport> {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final Injector<ActorScheduler> schedulerInjector = new Injector();
    protected final Injector<Dispatcher> receiveBufferInjector = new Injector();
    protected final Injector<Dispatcher> sendBufferInjector = new Injector();
    protected final String readableName;
    protected final InetSocketAddress bindAddress;
    protected BufferingServerTransport serverTransport;

    public BufferingServerTransportService(String readableName, InetSocketAddress bindAddress) {
        this.readableName = readableName;
        this.bindAddress = bindAddress;
    }

    public void start(ServiceStartContext serviceContext) {
        ActorScheduler scheduler = (ActorScheduler)this.schedulerInjector.getValue();
        Dispatcher receiveBuffer = (Dispatcher)this.receiveBufferInjector.getValue();
        Dispatcher sendBuffer = (Dispatcher)this.sendBufferInjector.getValue();
        this.serverTransport = Transports.newServerTransport().bindAddress(this.bindAddress).sendBuffer(sendBuffer).scheduler(scheduler).buildBuffering(receiveBuffer);
        LOG.info("Bound {} to {}", (Object)this.readableName, (Object)this.bindAddress);
    }

    public void stop(ServiceStopContext serviceStopContext) {
        serviceStopContext.async(this.serverTransport.closeAsync());
    }

    public BufferingServerTransport get() {
        return this.serverTransport;
    }

    public Injector<Dispatcher> getReceiveBufferInjector() {
        return this.receiveBufferInjector;
    }

    public Injector<Dispatcher> getSendBufferInjector() {
        return this.sendBufferInjector;
    }

    public Injector<ActorScheduler> getSchedulerInjector() {
        return this.schedulerInjector;
    }
}

