/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.Transports;
import io.zeebe.util.actor.ActorScheduler;

public class ClientTransportService
implements Service<ClientTransport> {
    protected final Injector<ActorScheduler> schedulerInjector = new Injector();
    protected final Injector<Dispatcher> receiveBufferInjector = new Injector();
    protected final Injector<Dispatcher> sendBufferInjector = new Injector();
    protected final int requestPoolSize;
    protected ClientTransport transport;

    public ClientTransportService(int requestPoolSize) {
        this.requestPoolSize = requestPoolSize;
    }

    public void start(ServiceStartContext startContext) {
        Dispatcher receiveBuffer = (Dispatcher)this.receiveBufferInjector.getValue();
        Dispatcher sendBuffer = (Dispatcher)this.sendBufferInjector.getValue();
        ActorScheduler scheduler = (ActorScheduler)this.schedulerInjector.getValue();
        this.transport = Transports.newClientTransport().messageReceiveBuffer(receiveBuffer).sendBuffer(sendBuffer).requestPoolSize(this.requestPoolSize).scheduler(scheduler).build();
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.transport.closeAsync());
    }

    public ClientTransport get() {
        return this.transport;
    }

    public Injector<Dispatcher> getSendBufferInjector() {
        return this.sendBufferInjector;
    }

    public Injector<Dispatcher> getReceiveBufferInjector() {
        return this.receiveBufferInjector;
    }

    public Injector<ActorScheduler> getSchedulerInjector() {
        return this.schedulerInjector;
    }
}

