/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.Transports;
import io.zeebe.util.actor.ActorScheduler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public class ServerTransportService
implements Service<ServerTransport> {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final Injector<ActorScheduler> schedulerInjector = new Injector();
    protected final Injector<Dispatcher> sendBufferInjector = new Injector();
    protected final Injector<ServerRequestHandler> requestHandlerInjector = new Injector();
    protected final Injector<ServerMessageHandler> messageHandlerInjector = new Injector();
    protected final String readableName;
    protected final InetSocketAddress bindAddress;
    protected ServerTransport serverTransport;

    public ServerTransportService(String readableName, InetSocketAddress bindAddress) {
        this.readableName = readableName;
        this.bindAddress = bindAddress;
    }

    public void start(ServiceStartContext serviceContext) {
        ActorScheduler scheduler = (ActorScheduler)this.schedulerInjector.getValue();
        Dispatcher sendBuffer = (Dispatcher)this.sendBufferInjector.getValue();
        ServerRequestHandler requestHandler = (ServerRequestHandler)this.requestHandlerInjector.getValue();
        ServerMessageHandler messageHandler = (ServerMessageHandler)this.messageHandlerInjector.getValue();
        this.serverTransport = Transports.newServerTransport().bindAddress(this.bindAddress).sendBuffer(sendBuffer).scheduler(scheduler).build(messageHandler, requestHandler);
        LOG.info("Bound {} to {}", (Object)this.readableName, (Object)this.bindAddress);
    }

    public void stop(ServiceStopContext serviceStopContext) {
        serviceStopContext.async(this.serverTransport.closeAsync());
    }

    public ServerTransport get() {
        return this.serverTransport;
    }

    public Injector<Dispatcher> getSendBufferInjector() {
        return this.sendBufferInjector;
    }

    public Injector<ServerRequestHandler> getRequestHandlerInjector() {
        return this.requestHandlerInjector;
    }

    public Injector<ServerMessageHandler> getMessageHandlerInjector() {
        return this.messageHandlerInjector;
    }

    public Injector<ActorScheduler> getSchedulerInjector() {
        return this.schedulerInjector;
    }
}

