/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport;

import io.zeebe.broker.clustering.ClusterServiceNames;
import io.zeebe.broker.event.TopicSubscriptionServiceNames;
import io.zeebe.broker.logstreams.LogStreamServiceNames;
import io.zeebe.broker.services.DispatcherService;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.task.TaskQueueServiceNames;
import io.zeebe.broker.transport.BufferingServerTransportService;
import io.zeebe.broker.transport.ClientTransportService;
import io.zeebe.broker.transport.ServerTransportService;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.broker.transport.cfg.SocketBindingCfg;
import io.zeebe.broker.transport.cfg.TransportComponentCfg;
import io.zeebe.broker.transport.clientapi.ClientApiMessageHandlerService;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandlerManagerService;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.DispatcherBuilder;
import io.zeebe.dispatcher.Dispatchers;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.SocketAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public class TransportComponent
implements Component {
    protected static final int MGMT_REQUEST_POOL_SIZE = 128;

    @Override
    public void init(SystemContext context) {
        TransportComponentCfg transportComponentCfg = context.getConfigurationManager().readEntry("network", TransportComponentCfg.class);
        ServiceContainer serviceContainer = context.getServiceContainer();
        CompletableFuture<Void> replactionApiFuture = this.bindBufferingProtocolEndpoint(serviceContainer, "replicationApi.server", transportComponentCfg.replicationApi, transportComponentCfg);
        CompletableFuture<Void> managementApiFuture = this.bindBufferingProtocolEndpoint(serviceContainer, "managementApi.server", transportComponentCfg.managementApi, transportComponentCfg);
        CompletableFuture<Void> clientApiFuture = this.bindNonBufferingProtocolEndpoint(serviceContainer, "clientApi.server", transportComponentCfg.clientApi, transportComponentCfg, TransportServiceNames.CLIENT_API_MESSAGE_HANDLER, TransportServiceNames.CLIENT_API_MESSAGE_HANDLER);
        CompletableFuture<Void> managementClientFuture = this.createClientTransport(serviceContainer, "managementApi.client", transportComponentCfg.managementApi.getReceiveBufferSize(transportComponentCfg.defaultReceiveBufferSize), 128);
        CompletableFuture<Void> replicationClientFuture = this.createClientTransport(serviceContainer, "replicationApi.client", transportComponentCfg.replicationApi.getReceiveBufferSize(transportComponentCfg.defaultReceiveBufferSize), 128);
        ServiceName<Dispatcher> controlMessageBufferService = this.createReceiveBuffer(serviceContainer, "clientApi.server", transportComponentCfg.clientApi.getReceiveBufferSize(transportComponentCfg.defaultReceiveBufferSize), "control-message-handler");
        ClientApiMessageHandlerService messageHandlerService = new ClientApiMessageHandlerService();
        serviceContainer.createService(TransportServiceNames.CLIENT_API_MESSAGE_HANDLER, (Service)messageHandlerService).dependency(controlMessageBufferService, messageHandlerService.getControlMessageBufferInjector()).groupReference(LogStreamServiceNames.LOG_STREAM_SERVICE_GROUP, messageHandlerService.getLogStreamsGroupReference()).install();
        long controlMessageRequestTimeoutInMillis = transportComponentCfg.clientApi.getControlMessageRequestTimeoutInMillis(Long.MAX_VALUE);
        ControlMessageHandlerManagerService controlMessageHandlerManagerService = new ControlMessageHandlerManagerService(controlMessageRequestTimeoutInMillis);
        CompletableFuture controlMessageServiceFuture = serviceContainer.createService(TransportServiceNames.CONTROL_MESSAGE_HANDLER_MANAGER, (Service)controlMessageHandlerManagerService).dependency(controlMessageBufferService, controlMessageHandlerManagerService.getControlMessageBufferInjector()).dependency(TransportServiceNames.serverTransport("clientApi.server"), controlMessageHandlerManagerService.getTransportInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, controlMessageHandlerManagerService.getActorSchedulerInjector()).dependency(TaskQueueServiceNames.TASK_QUEUE_SUBSCRIPTION_MANAGER, controlMessageHandlerManagerService.getTaskSubscriptionManagerInjector()).dependency(TopicSubscriptionServiceNames.TOPIC_SUBSCRIPTION_SERVICE, controlMessageHandlerManagerService.getTopicSubscriptionServiceInjector()).dependency(ClusterServiceNames.GOSSIP_SERVICE, controlMessageHandlerManagerService.getGossipInjector()).install();
        context.addRequiredStartAction(replactionApiFuture);
        context.addRequiredStartAction(managementApiFuture);
        context.addRequiredStartAction(clientApiFuture);
        context.addRequiredStartAction(managementClientFuture);
        context.addRequiredStartAction(replicationClientFuture);
        context.addRequiredStartAction(controlMessageServiceFuture);
    }

    protected CompletableFuture<Void> bindBufferingProtocolEndpoint(ServiceContainer serviceContainer, String name, SocketBindingCfg socketBindingCfg, TransportComponentCfg defaultConfig) {
        SocketAddress bindAddr = new SocketAddress(socketBindingCfg.getHost(defaultConfig.host), socketBindingCfg.getPort());
        return this.createBufferingServerTransport(serviceContainer, name, bindAddr.toInetSocketAddress(), socketBindingCfg.getSendBufferSize(defaultConfig.sendBufferSize), socketBindingCfg.getReceiveBufferSize(defaultConfig.defaultReceiveBufferSize));
    }

    protected CompletableFuture<Void> bindNonBufferingProtocolEndpoint(ServiceContainer serviceContainer, String name, SocketBindingCfg socketBindingCfg, TransportComponentCfg defaultConfig, ServiceName<? extends ServerRequestHandler> requestHandlerService, ServiceName<? extends ServerMessageHandler> messageHandlerService) {
        SocketAddress bindAddr = new SocketAddress(socketBindingCfg.getHost(defaultConfig.host), socketBindingCfg.getPort());
        return this.createServerTransport(serviceContainer, name, bindAddr.toInetSocketAddress(), socketBindingCfg.getSendBufferSize(defaultConfig.sendBufferSize), requestHandlerService, messageHandlerService);
    }

    protected CompletableFuture<Void> createServerTransport(ServiceContainer serviceContainer, String name, InetSocketAddress bindAddress, int sendBufferSize, ServiceName<? extends ServerRequestHandler> requestHandlerDependency, ServiceName<? extends ServerMessageHandler> messageHandlerDependency) {
        ServiceName<Dispatcher> sendBufferName = this.createSendBuffer(serviceContainer, name, sendBufferSize);
        ServerTransportService service = new ServerTransportService(name, bindAddress);
        return serviceContainer.createService(TransportServiceNames.serverTransport(name), (Service)service).dependency(sendBufferName, service.getSendBufferInjector()).dependency(requestHandlerDependency, service.getRequestHandlerInjector()).dependency(messageHandlerDependency, service.getMessageHandlerInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, service.getSchedulerInjector()).install();
    }

    protected CompletableFuture<Void> createBufferingServerTransport(ServiceContainer serviceContainer, String name, InetSocketAddress bindAddress, int sendBufferSize, int receiveBufferSize) {
        ServiceName<Dispatcher> sendBufferName = this.createSendBuffer(serviceContainer, name, sendBufferSize);
        ServiceName<Dispatcher> receiveBufferName = this.createReceiveBuffer(serviceContainer, name, receiveBufferSize, new String[0]);
        BufferingServerTransportService service = new BufferingServerTransportService(name, bindAddress);
        return serviceContainer.createService(TransportServiceNames.bufferingServerTransport(name), (Service)service).dependency(receiveBufferName, service.getReceiveBufferInjector()).dependency(sendBufferName, service.getSendBufferInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, service.getSchedulerInjector()).install();
    }

    protected void createDispatcher(ServiceContainer serviceContainer, ServiceName<Dispatcher> name, int bufferSize, String ... subscriptions) {
        DispatcherBuilder dispatcherBuilder = Dispatchers.create(null).bufferSize(bufferSize).subscriptions(subscriptions);
        DispatcherService receiveBufferService = new DispatcherService(dispatcherBuilder);
        serviceContainer.createService(name, (Service)receiveBufferService).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, receiveBufferService.getActorSchedulerInjector()).dependency(SystemServiceNames.COUNTERS_MANAGER_SERVICE, receiveBufferService.getCountersManagerInjector()).install();
    }

    protected ServiceName<Dispatcher> createSendBuffer(ServiceContainer serviceContainer, String transportName, int bufferSize) {
        ServiceName<Dispatcher> serviceName = TransportServiceNames.sendBufferName(transportName);
        this.createDispatcher(serviceContainer, serviceName, bufferSize, "sender");
        return serviceName;
    }

    protected ServiceName<Dispatcher> createReceiveBuffer(ServiceContainer serviceContainer, String transportName, int bufferSize, String ... subscriptionNames) {
        ServiceName<Dispatcher> serviceName = TransportServiceNames.receiveBufferName(transportName);
        this.createDispatcher(serviceContainer, serviceName, bufferSize, subscriptionNames);
        return serviceName;
    }

    protected CompletableFuture<Void> createClientTransport(ServiceContainer serviceContainer, String name, int receiveBufferSize, int requestPoolSize) {
        ServiceName<Dispatcher> receiveBufferName = this.createReceiveBuffer(serviceContainer, name, receiveBufferSize, new String[0]);
        ServiceName<Dispatcher> sendBufferName = this.createSendBuffer(serviceContainer, name, receiveBufferSize);
        ClientTransportService service = new ClientTransportService(requestPoolSize);
        return serviceContainer.createService(TransportServiceNames.clientTransport(name), (Service)service).dependency(receiveBufferName, service.getReceiveBufferInjector()).dependency(sendBufferName, service.getSendBufferInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, service.getSchedulerInjector()).install();
    }
}

