/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.cfg;

import io.zeebe.broker.system.ComponentConfiguration;

public class SocketBindingCfg
extends ComponentConfiguration {
    public String host;
    public int port = -1;
    public int receiveBufferSize = -1;
    public int sendBufferSize = -1;
    public long controlMessageRequestTimeoutInMillis = 10000L;

    public String getHost(String defaultValue) {
        return this.getOrDefault(this.host, defaultValue);
    }

    public int getPort() {
        return this.port;
    }

    public int getReceiveBufferSize(int defaultValue) {
        return this.getBufferSize(this.receiveBufferSize, defaultValue);
    }

    public int getSendBufferSize(int defaultValue) {
        return this.getBufferSize(this.sendBufferSize, defaultValue);
    }

    protected int getBufferSize(int configuredValue, int defaultValue) {
        int receiveBufferSize = configuredValue;
        if (receiveBufferSize == -1) {
            receiveBufferSize = defaultValue;
        }
        int receiveBufferSizeInByte = receiveBufferSize * 1024 * 1024;
        return receiveBufferSizeInByte;
    }

    public long getControlMessageRequestTimeoutInMillis(long defaultValue) {
        long returnValue = this.controlMessageRequestTimeoutInMillis;
        if (returnValue < 0L) {
            returnValue = defaultValue;
        }
        return returnValue;
    }
}

