/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.clientapi;

import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.clientapi.ExecuteCommandResponseEncoder;
import io.zeebe.protocol.clientapi.MessageHeaderEncoder;
import io.zeebe.protocol.clientapi.SubscribedEventEncoder;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.util.buffer.BufferWriter;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CommandResponseWriter
implements BufferWriter {
    protected final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    protected final ExecuteCommandResponseEncoder responseEncoder = new ExecuteCommandResponseEncoder();
    protected DirectBuffer topicName = new UnsafeBuffer(0L, 0);
    protected int partitionId = ExecuteCommandResponseEncoder.partitionIdNullValue();
    protected long position = SubscribedEventEncoder.positionNullValue();
    protected long key = ExecuteCommandResponseEncoder.keyNullValue();
    protected BufferWriter eventWriter;
    protected final ServerResponse response = new ServerResponse();
    protected final ServerOutput output;

    public CommandResponseWriter(ServerOutput output) {
        this.output = output;
    }

    public CommandResponseWriter topicName(DirectBuffer topicName) {
        this.topicName.wrap(topicName);
        return this;
    }

    public CommandResponseWriter partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public CommandResponseWriter position(long position) {
        this.position = position;
        return this;
    }

    public CommandResponseWriter key(long key) {
        this.key = key;
        return this;
    }

    public CommandResponseWriter eventWriter(BufferWriter writer) {
        this.eventWriter = writer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteResponse(int remoteStreamId, long requestId) {
        Objects.requireNonNull(this.eventWriter);
        try {
            this.response.reset().remoteStreamId(remoteStreamId).requestId(requestId).writer((BufferWriter)this);
            boolean bl = this.output.sendResponse(this.response);
            return bl;
        }
        finally {
            this.reset();
        }
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset).blockLength(this.responseEncoder.sbeBlockLength()).templateId(this.responseEncoder.sbeTemplateId()).schemaId(this.responseEncoder.sbeSchemaId()).version(this.responseEncoder.sbeSchemaVersion());
        this.responseEncoder.wrap(buffer, offset += this.messageHeaderEncoder.encodedLength()).putTopicName(this.topicName, 0, this.topicName.capacity()).partitionId(this.partitionId).position(this.position).key(this.key);
        offset = this.responseEncoder.limit();
        int eventLength = this.eventWriter.getLength();
        buffer.putShort(offset, (short)eventLength, Protocol.ENDIANNESS);
        this.eventWriter.write(buffer, offset += ExecuteCommandResponseEncoder.eventHeaderLength());
    }

    public int getLength() {
        return 26 + ExecuteCommandResponseEncoder.topicNameHeaderLength() + this.topicName.capacity() + ExecuteCommandResponseEncoder.eventHeaderLength() + this.eventWriter.getLength();
    }

    protected void reset() {
        this.topicName.wrap(0L, 0);
        this.partitionId = ExecuteCommandResponseEncoder.partitionIdNullValue();
        this.key = ExecuteCommandResponseEncoder.keyNullValue();
        this.eventWriter = null;
    }
}

