/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.clientapi;

import io.zeebe.broker.Loggers;
import io.zeebe.protocol.clientapi.ErrorCode;
import io.zeebe.protocol.clientapi.ErrorResponseEncoder;
import io.zeebe.protocol.clientapi.MessageHeaderEncoder;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.StringUtil;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class ErrorResponseWriter
implements BufferWriter {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    protected final ErrorResponseEncoder errorResponseEncoder = new ErrorResponseEncoder();
    protected final DirectBuffer failedRequestBuffer = new UnsafeBuffer(0L, 0);
    protected ErrorCode errorCode;
    protected byte[] errorMessage;
    protected final ServerOutput output;
    protected final ServerResponse response = new ServerResponse();

    public ErrorResponseWriter() {
        this(null);
    }

    public ErrorResponseWriter(ServerOutput output) {
        this.output = output;
    }

    public ErrorResponseWriter errorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public ErrorResponseWriter errorMessage(String errorMessage) {
        this.errorMessage = StringUtil.getBytes((String)errorMessage);
        return this;
    }

    public ErrorResponseWriter errorMessage(String errorMessage, Object ... args) {
        this.errorMessage = StringUtil.getBytes((String)String.format(errorMessage, args));
        return this;
    }

    public ErrorResponseWriter failedRequest(DirectBuffer buffer, int offset, int length) {
        this.failedRequestBuffer.wrap(buffer, offset, length);
        return this;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset);
        this.messageHeaderEncoder.blockLength(this.errorResponseEncoder.sbeBlockLength()).templateId(this.errorResponseEncoder.sbeTemplateId()).schemaId(this.errorResponseEncoder.sbeSchemaId()).version(this.errorResponseEncoder.sbeSchemaVersion());
        this.errorResponseEncoder.wrap(buffer, offset += this.messageHeaderEncoder.encodedLength());
        this.errorResponseEncoder.errorCode(this.errorCode).putErrorData(this.errorMessage, 0, this.errorMessage.length).putFailedRequest(this.failedRequestBuffer, 0, this.failedRequestBuffer.capacity());
    }

    public boolean tryWriteResponseOrLogFailure(ServerOutput output, int streamId, long requestId) {
        boolean isWritten = this.tryWriteResponse(output, streamId, requestId);
        if (!isWritten) {
            LOG.error("Failed to write error response. Error code: '{}', error message: '{}'", (Object)this.errorCode.name(), (Object)new String(this.errorMessage, StandardCharsets.UTF_8));
        }
        return isWritten;
    }

    public boolean tryWriteResponseOrLogFailure(int streamId, long requestId) {
        return this.tryWriteResponseOrLogFailure(this.output, streamId, requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteResponse(ServerOutput output, int streamId, long requestId) {
        EnsureUtil.ensureNotNull((String)"error code", (Object)this.errorCode);
        EnsureUtil.ensureNotNull((String)"error message", (Object)this.errorMessage);
        try {
            this.response.reset().remoteStreamId(streamId).writer((BufferWriter)this).requestId(requestId);
            boolean bl = output.sendResponse(this.response);
            return bl;
        }
        finally {
            this.reset();
        }
    }

    public boolean tryWriteResponse(int streamId, long requestId) {
        return this.tryWriteResponse(this.output, streamId, requestId);
    }

    public int getLength() {
        return 9 + ErrorResponseEncoder.errorDataHeaderLength() + this.errorMessage.length + ErrorResponseEncoder.failedRequestHeaderLength() + this.failedRequestBuffer.capacity();
    }

    protected void reset() {
        this.errorCode = null;
        this.errorMessage = null;
        this.failedRequestBuffer.wrap(0L, 0);
    }
}

