/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.clientapi;

import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.clientapi.EventType;
import io.zeebe.protocol.clientapi.MessageHeaderEncoder;
import io.zeebe.protocol.clientapi.SubscribedEventEncoder;
import io.zeebe.protocol.clientapi.SubscriptionType;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.TransportMessage;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SubscribedEventWriter
implements BufferWriter {
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final SubscribedEventEncoder bodyEncoder = new SubscribedEventEncoder();
    protected DirectBuffer topicName = new UnsafeBuffer(0L, 0);
    protected int partitionId = SubscribedEventEncoder.partitionIdNullValue();
    protected long position = SubscribedEventEncoder.positionNullValue();
    protected long key = SubscribedEventEncoder.keyNullValue();
    protected long subscriberKey = SubscribedEventEncoder.subscriberKeyNullValue();
    protected SubscriptionType subscriptionType;
    protected EventType eventType;
    protected DirectBufferWriter eventBuffer = new DirectBufferWriter();
    protected BufferWriter eventWriter;
    protected final ServerOutput output;
    protected final TransportMessage message = new TransportMessage();

    public SubscribedEventWriter(ServerOutput output) {
        this.output = output;
    }

    public SubscribedEventWriter topicName(DirectBuffer topicName) {
        this.topicName.wrap(topicName);
        return this;
    }

    public SubscribedEventWriter partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public SubscribedEventWriter position(long position) {
        this.position = position;
        return this;
    }

    public SubscribedEventWriter key(long key) {
        this.key = key;
        return this;
    }

    public SubscribedEventWriter subscriberKey(long subscriberKey) {
        this.subscriberKey = subscriberKey;
        return this;
    }

    public SubscribedEventWriter subscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    public SubscribedEventWriter eventType(EventType eventType) {
        this.eventType = eventType;
        return this;
    }

    public SubscribedEventWriter event(DirectBuffer buffer, int offset, int length) {
        this.eventBuffer.wrap(buffer, offset, length);
        this.eventWriter = this.eventBuffer;
        return this;
    }

    public SubscribedEventWriter eventWriter(BufferWriter eventWriter) {
        this.eventWriter = eventWriter;
        return this;
    }

    public int getLength() {
        return 36 + SubscribedEventEncoder.topicNameHeaderLength() + this.topicName.capacity() + SubscribedEventEncoder.eventHeaderLength() + this.eventWriter.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += 8).partitionId(this.partitionId).putTopicName(this.topicName, 0, this.topicName.capacity()).position(this.position).key(this.key).subscriberKey(this.subscriberKey).subscriptionType(this.subscriptionType).eventType(this.eventType);
        int eventLength = this.eventWriter.getLength();
        buffer.putShort(offset += 28 + SubscribedEventEncoder.topicNameHeaderLength() + this.topicName.capacity(), (short)eventLength, Protocol.ENDIANNESS);
        this.eventWriter.write(buffer, offset += SubscribedEventEncoder.eventHeaderLength());
    }

    public boolean tryWriteMessage(int remoteStreamId) {
        Objects.requireNonNull(this.eventWriter);
        try {
            this.message.reset().remoteStreamId(remoteStreamId).writer((BufferWriter)this);
            boolean bl = this.output.sendMessage(this.message);
            return bl;
        }
        finally {
            this.reset();
        }
    }

    protected void reset() {
        this.partitionId = SubscribedEventEncoder.partitionIdNullValue();
        this.topicName.wrap(0L, 0);
        this.position = SubscribedEventEncoder.positionNullValue();
        this.key = SubscribedEventEncoder.keyNullValue();
        this.subscriberKey = SubscribedEventEncoder.subscriberKeyNullValue();
        this.subscriptionType = SubscriptionType.NULL_VAL;
        this.eventType = EventType.NULL_VAL;
        this.eventWriter = null;
    }
}

