/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.broker.task.TaskSubscriptionManager;
import io.zeebe.broker.task.processor.TaskSubscription;
import io.zeebe.broker.task.processor.TaskSubscriptionRequest;
import io.zeebe.broker.transport.clientapi.ErrorResponseWriter;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandler;
import io.zeebe.broker.transport.controlmessage.ControlMessageResponseWriter;
import io.zeebe.protocol.clientapi.ControlMessageType;
import io.zeebe.protocol.clientapi.ErrorCode;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.transport.ServerOutput;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class AddTaskSubscriptionHandler
implements ControlMessageHandler {
    protected final TaskSubscriptionRequest request = new TaskSubscriptionRequest();
    protected final TaskSubscriptionManager manager;
    protected final ControlMessageResponseWriter responseWriter;
    protected final ErrorResponseWriter errorResponseWriter;

    public AddTaskSubscriptionHandler(ServerOutput output, TaskSubscriptionManager manager) {
        this.manager = manager;
        this.errorResponseWriter = new ErrorResponseWriter(output);
        this.responseWriter = new ControlMessageResponseWriter(output);
    }

    @Override
    public ControlMessageType getMessageType() {
        return ControlMessageType.ADD_TASK_SUBSCRIPTION;
    }

    @Override
    public CompletableFuture<Void> handle(DirectBuffer buffer, BrokerEventMetadata eventMetada) {
        this.request.reset();
        this.request.wrap(buffer);
        long requestId = eventMetada.getRequestId();
        int requestStreamId = eventMetada.getRequestStreamId();
        TaskSubscription taskSubscription = new TaskSubscription(this.request.getTopicName(), this.request.getPartitionId(), this.request.getLockTaskType(), this.request.getLockDuration(), this.request.getLockOwner(), requestStreamId);
        taskSubscription.setCredits(this.request.getCredits());
        CompletableFuture<Void> future = this.manager.addSubscription(taskSubscription);
        return future.handle((v, failure) -> {
            if (failure == null) {
                this.request.setSubscriberKey(taskSubscription.getSubscriberKey());
                boolean bl = this.responseWriter.dataWriter((BufferWriter)this.request).tryWriteResponse(eventMetada.getRequestStreamId(), eventMetada.getRequestId());
            } else {
                this.errorResponseWriter.errorCode(ErrorCode.REQUEST_PROCESSING_FAILURE).errorMessage("Cannot add task subscription. %s", failure.getMessage()).failedRequest(buffer, 0, buffer.capacity()).tryWriteResponseOrLogFailure(requestStreamId, requestId);
            }
            return null;
        });
    }
}

