/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.broker.clustering.gossip.Gossip;
import io.zeebe.broker.clustering.handler.RequestTopologyHandler;
import io.zeebe.broker.event.handler.RemoveTopicSubscriptionHandler;
import io.zeebe.broker.event.processor.TopicSubscriptionService;
import io.zeebe.broker.task.TaskSubscriptionManager;
import io.zeebe.broker.transport.controlmessage.AddTaskSubscriptionHandler;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandler;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandlerManager;
import io.zeebe.broker.transport.controlmessage.IncreaseTaskSubscriptionCreditsHandler;
import io.zeebe.broker.transport.controlmessage.RemoveTaskSubscriptionHandler;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerTransport;
import io.zeebe.util.actor.ActorScheduler;
import java.util.Arrays;
import java.util.List;

public class ControlMessageHandlerManagerService
implements Service<ControlMessageHandlerManager> {
    protected final Injector<ServerTransport> transportInjector = new Injector();
    protected final Injector<Dispatcher> controlMessageBufferInjector = new Injector();
    protected final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    protected final Injector<TaskSubscriptionManager> taskSubscriptionManagerInjector = new Injector();
    protected final Injector<TopicSubscriptionService> topicSubscriptionServiceInjector = new Injector();
    protected final Injector<Gossip> gossipInjector = new Injector();
    protected final long controlMessageRequestTimeoutInMillis;
    protected ControlMessageHandlerManager service;

    public ControlMessageHandlerManagerService(long controlMessageRequestTimeoutInMillis) {
        this.controlMessageRequestTimeoutInMillis = controlMessageRequestTimeoutInMillis;
    }

    public void start(ServiceStartContext context) {
        Dispatcher controlMessageBuffer = (Dispatcher)this.controlMessageBufferInjector.getValue();
        ServerTransport transport = (ServerTransport)this.transportInjector.getValue();
        ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
        TaskSubscriptionManager taskSubscriptionManager = (TaskSubscriptionManager)this.taskSubscriptionManagerInjector.getValue();
        TopicSubscriptionService topicSubscriptionService = (TopicSubscriptionService)this.topicSubscriptionServiceInjector.getValue();
        Gossip gossip = (Gossip)this.gossipInjector.getValue();
        ServerOutput output = transport.getOutput();
        List<ControlMessageHandler> controlMessageHandlers = Arrays.asList(new AddTaskSubscriptionHandler(output, taskSubscriptionManager), new IncreaseTaskSubscriptionCreditsHandler(output, taskSubscriptionManager), new RemoveTaskSubscriptionHandler(output, taskSubscriptionManager), new RemoveTopicSubscriptionHandler(output, topicSubscriptionService), new RequestTopologyHandler(output, gossip));
        this.service = new ControlMessageHandlerManager(transport.getOutput(), controlMessageBuffer, this.controlMessageRequestTimeoutInMillis, actorScheduler, controlMessageHandlers);
        context.async(this.service.openAsync());
    }

    public void stop(ServiceStopContext context) {
        context.async(this.service.closeAsync());
    }

    public ControlMessageHandlerManager get() {
        return this.service;
    }

    public Injector<ServerTransport> getTransportInjector() {
        return this.transportInjector;
    }

    public Injector<Dispatcher> getControlMessageBufferInjector() {
        return this.controlMessageBufferInjector;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public Injector<TaskSubscriptionManager> getTaskSubscriptionManagerInjector() {
        return this.taskSubscriptionManagerInjector;
    }

    public Injector<TopicSubscriptionService> getTopicSubscriptionServiceInjector() {
        return this.topicSubscriptionServiceInjector;
    }

    public Injector<Gossip> getGossipInjector() {
        return this.gossipInjector;
    }
}

