/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.protocol.Protocol;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ControlMessageRequestHeaderDescriptor {
    public static final int STREAM_ID_OFFSET;
    public static final int REQUEST_ID_OFFSET;
    public static final int HEADER_LENGTH;
    protected final UnsafeBuffer buffer = new UnsafeBuffer(new byte[HEADER_LENGTH]);

    public static int framedLength(int messageLength) {
        return HEADER_LENGTH + messageLength;
    }

    public static int headerLength() {
        return HEADER_LENGTH;
    }

    public ControlMessageRequestHeaderDescriptor wrap(DirectBuffer buffer, int offset) {
        this.buffer.wrap(buffer, offset, HEADER_LENGTH);
        return this;
    }

    public ControlMessageRequestHeaderDescriptor streamId(int streamId) {
        this.buffer.putInt(STREAM_ID_OFFSET, streamId, Protocol.ENDIANNESS);
        return this;
    }

    public ControlMessageRequestHeaderDescriptor requestId(long requestId) {
        this.buffer.putLong(REQUEST_ID_OFFSET, requestId, Protocol.ENDIANNESS);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(STREAM_ID_OFFSET, Protocol.ENDIANNESS);
    }

    public long requestId() {
        return this.buffer.getLong(REQUEST_ID_OFFSET, Protocol.ENDIANNESS);
    }

    static {
        int offset;
        STREAM_ID_OFFSET = offset = 0;
        REQUEST_ID_OFFSET = offset += 4;
        HEADER_LENGTH = offset += 8;
    }
}

